/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.util.Apps;
import org.junit.Assert;
import org.junit.Test;

public class TestApps {
    @Test
    public void testSetEnvFromInputString() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("JAVA_HOME", "/path/jdk");
        String goodEnv = "a1=1,b_2=2,_c=3,d=4,e=,f_win=%JAVA_HOME%,g_nix=$JAVA_HOME";
        Apps.setEnvFromInputString(environment, (String)goodEnv, (String)File.pathSeparator);
        Assert.assertEquals((Object)"1", environment.get("a1"));
        Assert.assertEquals((Object)"2", environment.get("b_2"));
        Assert.assertEquals((Object)"3", environment.get("_c"));
        Assert.assertEquals((Object)"4", environment.get("d"));
        Assert.assertEquals((Object)"", environment.get("e"));
        if (Shell.WINDOWS) {
            Assert.assertEquals((Object)"$JAVA_HOME", environment.get("g_nix"));
            Assert.assertEquals((Object)"/path/jdk", environment.get("f_win"));
        } else {
            Assert.assertEquals((Object)"/path/jdk", environment.get("g_nix"));
            Assert.assertEquals((Object)"%JAVA_HOME%", environment.get("f_win"));
        }
        String badEnv = "1,,2=a=b,3=a=,4==,5==a,==,c-3=3,=";
        environment.clear();
        Apps.setEnvFromInputString(environment, (String)badEnv, (String)File.pathSeparator);
        Assert.assertEquals((long)environment.size(), (long)0L);
        environment.clear();
        Apps.setEnvFromInputString(environment, (String)"b1,e1==,e2=a1=a2,b2", (String)File.pathSeparator);
        Assert.assertEquals((Object)"=", environment.get("e1"));
        Assert.assertEquals((Object)"a1=a2", environment.get("e2"));
    }

    @Test
    public void testSetEnvFromInputProperty() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.map.env";
        String defaultPropName = "mapreduce.child.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env4", "env4_val");
        conf.set(propName + ".env2", "new_env2_val");
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        Apps.setEnvFromInputProperty(env, (String)propName, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        Assert.assertEquals((Object)"env1_val", env.get("env1"));
        Assert.assertEquals((Object)"env3_val", env.get("env3"));
        Assert.assertEquals((Object)"env4_val", env.get("env4"));
        Assert.assertEquals((Object)"new_env2_val", env.get("env2"));
    }

    @Test
    public void testSetEnvFromInputPropertyDefault() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.map.env";
        String defaultPropName = "mapreduce.child.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env4", "env4_val");
        conf.set(propName + ".env2", "new_env2_val");
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        String bogusProp = propName + "bogus";
        Apps.setEnvFromInputProperty(env, (String)bogusProp, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        Assert.assertEquals((Object)"def1_val", env.get("env1"));
        Assert.assertEquals((Object)"def2_val", env.get("env2"));
        Assert.assertEquals((Object)"def3_val", env.get("env3"));
        Assert.assertNull(env.get("env4"));
    }

    @Test
    public void testSetEnvFromInputPropertyOverrideDefault() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.reduce.env";
        conf.set(propName + ".env2", "new2_val");
        conf.set(propName + ".env4", "new4_val");
        String defaultPropName = "mapreduce.child.env";
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        Apps.setEnvFromInputProperty(env, (String)propName, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        Assert.assertEquals((Object)"def1_val", env.get("env1"));
        Assert.assertEquals((Object)"def3_val", env.get("env3"));
        Assert.assertEquals((Object)"new4_val", env.get("env4"));
        Assert.assertEquals((Object)"new2_val", env.get("env2"));
    }

    @Test
    public void testSetEnvFromInputPropertyCommas() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.reduce.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env2", "new2_val1,new2_val2,new2_val3");
        conf.set(propName + ".env4", "new4_valwith=equals");
        String defaultPropName = "mapreduce.child.env";
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        Apps.setEnvFromInputProperty(env, (String)propName, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        Assert.assertEquals((Object)"env1_val", env.get("env1"));
        Assert.assertEquals((Object)"env3_val", env.get("env3"));
        Assert.assertEquals((Object)"new4_valwith=equals", env.get("env4"));
        Assert.assertEquals((Object)"new2_val1,new2_val2,new2_val3", env.get("env2"));
    }

    @Test
    public void testSetEnvFromInputPropertyNull() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.map.env";
        String defaultPropName = "mapreduce.child.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env4", "env4_val");
        conf.set(propName + ".env2", "new_env2_val");
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        Apps.setEnvFromInputProperty(env, (String)"bogus1", null, (Configuration)conf, (String)File.pathSeparator);
        Assert.assertTrue((boolean)env.isEmpty());
    }
}

