/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.util.Log4jWarningErrorMetricsAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestLog4jWarningErrorMetricsAppender {
    Log4jWarningErrorMetricsAppender appender;
    Log logger = LogFactory.getLog(TestLog4jWarningErrorMetricsAppender.class);
    List<Long> cutoff = new ArrayList<Long>();

    void setupAppender(int cleanupIntervalSeconds, long messageAgeLimitSeconds, int maxUniqueMessages) {
        this.removeAppender();
        this.appender = new Log4jWarningErrorMetricsAppender(cleanupIntervalSeconds, messageAgeLimitSeconds, maxUniqueMessages);
        Logger.getRootLogger().addAppender((Appender)this.appender);
    }

    void removeAppender() {
        Logger.getRootLogger().removeAppender((Appender)this.appender);
    }

    void logMessages(Level level, String message, int count) {
        block8: for (int i = 0; i < count; ++i) {
            switch (level.toInt()) {
                case 50000: {
                    this.logger.fatal((Object)message);
                    continue block8;
                }
                case 40000: {
                    this.logger.error((Object)message);
                    continue block8;
                }
                case 30000: {
                    this.logger.warn((Object)message);
                    continue block8;
                }
                case 20000: {
                    this.logger.info((Object)message);
                    continue block8;
                }
                case 10000: {
                    this.logger.debug((Object)message);
                    continue block8;
                }
                case 5000: {
                    this.logger.trace((Object)message);
                }
            }
        }
    }

    @Test
    public void testPurge() throws Exception {
        this.setupAppender(2, 1L, 1);
        this.logMessages(Level.ERROR, "test message 1", 1);
        this.cutoff.clear();
        this.cutoff.add(0L);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)1L, (long)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        Thread.sleep(3000L);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)0L, (long)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        this.setupAppender(2, 1000L, 2);
        this.logMessages(Level.ERROR, "test message 1", 3);
        this.logMessages(Level.ERROR, "test message 2", 2);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)5L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)2L, (long)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        this.logMessages(Level.ERROR, "test message 3", 3);
        Thread.sleep(2000L);
        Assert.assertEquals((long)8L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)2L, (long)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
    }

    @Test
    public void testErrorCounts() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.ERROR, "test message 1", 2);
        this.logMessages(Level.ERROR, "test message 2", 3);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)this.appender.getWarningCounts(this.cutoff).size());
        Assert.assertEquals((long)5L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.ERROR, "test message 3", 2);
        Assert.assertEquals((long)2L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)2L, (long)this.appender.getWarningCounts(this.cutoff).size());
        Assert.assertEquals((long)7L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)2L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(1)).longValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(1)).longValue());
    }

    @Test
    public void testWarningCounts() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.WARN, "test message 1", 2);
        this.logMessages(Level.WARN, "test message 2", 3);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)this.appender.getWarningCounts(this.cutoff).size());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)5L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.WARN, "test message 3", 2);
        Assert.assertEquals((long)2L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)2L, (long)this.appender.getWarningCounts(this.cutoff).size());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(1)).longValue());
        Assert.assertEquals((long)7L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)2L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(1)).longValue());
    }

    @Test
    public void testWarningMessages() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.WARN, "test message 1", 2);
        this.logMessages(Level.WARN, "test message 2", 3);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        Map errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        Map warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assert.assertEquals((long)0L, (long)errorsMap.size());
        Assert.assertEquals((long)2L, (long)warningsMap.size());
        Assert.assertTrue((boolean)warningsMap.containsKey("test message 1"));
        Assert.assertTrue((boolean)warningsMap.containsKey("test message 2"));
        Log4jWarningErrorMetricsAppender.Element msg1Info = (Log4jWarningErrorMetricsAppender.Element)warningsMap.get("test message 1");
        Log4jWarningErrorMetricsAppender.Element msg2Info = (Log4jWarningErrorMetricsAppender.Element)warningsMap.get("test message 2");
        Assert.assertEquals((long)2L, (long)msg1Info.count.intValue());
        Assert.assertEquals((long)3L, (long)msg2Info.count.intValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.WARN, "test message 3", 2);
        Assert.assertEquals((long)2L, (long)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assert.assertEquals((long)2L, (long)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assert.assertEquals((long)0L, (long)errorsMap.size());
        Assert.assertEquals((long)3L, (long)warningsMap.size());
        Assert.assertTrue((boolean)warningsMap.containsKey("test message 3"));
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(1);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(1);
        Assert.assertEquals((long)0L, (long)errorsMap.size());
        Assert.assertEquals((long)1L, (long)warningsMap.size());
        Assert.assertTrue((boolean)warningsMap.containsKey("test message 3"));
        Log4jWarningErrorMetricsAppender.Element msg3Info = (Log4jWarningErrorMetricsAppender.Element)warningsMap.get("test message 3");
        Assert.assertEquals((long)2L, (long)msg3Info.count.intValue());
    }

    @Test
    public void testErrorMessages() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.ERROR, "test message 1", 2);
        this.logMessages(Level.ERROR, "test message 2", 3);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        Map errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        Map warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assert.assertEquals((long)2L, (long)errorsMap.size());
        Assert.assertEquals((long)0L, (long)warningsMap.size());
        Assert.assertTrue((boolean)errorsMap.containsKey("test message 1"));
        Assert.assertTrue((boolean)errorsMap.containsKey("test message 2"));
        Log4jWarningErrorMetricsAppender.Element msg1Info = (Log4jWarningErrorMetricsAppender.Element)errorsMap.get("test message 1");
        Log4jWarningErrorMetricsAppender.Element msg2Info = (Log4jWarningErrorMetricsAppender.Element)errorsMap.get("test message 2");
        Assert.assertEquals((long)2L, (long)msg1Info.count.intValue());
        Assert.assertEquals((long)3L, (long)msg2Info.count.intValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.ERROR, "test message 3", 2);
        Assert.assertEquals((long)2L, (long)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assert.assertEquals((long)2L, (long)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assert.assertEquals((long)3L, (long)errorsMap.size());
        Assert.assertEquals((long)0L, (long)warningsMap.size());
        Assert.assertTrue((boolean)errorsMap.containsKey("test message 3"));
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(1);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(1);
        Assert.assertEquals((long)1L, (long)errorsMap.size());
        Assert.assertEquals((long)0L, (long)warningsMap.size());
        Assert.assertTrue((boolean)errorsMap.containsKey("test message 3"));
        Log4jWarningErrorMetricsAppender.Element msg3Info = (Log4jWarningErrorMetricsAppender.Element)errorsMap.get("test message 3");
        Assert.assertEquals((long)2L, (long)msg3Info.count.intValue());
    }

    @Test
    public void testInfoDebugTrace() {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.INFO, "test message 1", 2);
        this.logMessages(Level.DEBUG, "test message 2", 2);
        this.logMessages(Level.TRACE, "test message 3", 2);
        Assert.assertEquals((long)1L, (long)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)this.appender.getErrorCounts(this.cutoff).size());
        Assert.assertEquals((long)1L, (long)this.appender.getWarningCounts(this.cutoff).size());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Assert.assertEquals((long)0L, (long)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        Assert.assertEquals((long)0L, (long)((Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0)).size());
    }
}

