/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.test;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.servlet.RequestScoped;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.mockito.Mockito;

public class WebAppTests {
    public static <T> Injector createMockInjector(final Class<T> api, final T impl, final Module ... modules) {
        return Guice.createInjector((Module[])new Module[]{new AbstractModule(){
            final PrintWriter writer = (PrintWriter)Mockito.spy((Object)new PrintWriter(System.out));
            final HttpServletRequest request = this.createRequest();
            final HttpServletResponse response = this.createResponse();

            protected void configure() {
                if (api != null) {
                    this.bind(api).toInstance(impl);
                }
                this.bindScope(RequestScoped.class, Scopes.SINGLETON);
                if (modules != null) {
                    for (Module module : modules) {
                        this.install(module);
                    }
                }
            }

            @Provides
            HttpServletRequest request() {
                return this.request;
            }

            @Provides
            HttpServletResponse response() {
                return this.response;
            }

            @Provides
            PrintWriter writer() {
                return this.writer;
            }

            HttpServletRequest createRequest() {
                return (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            }

            HttpServletResponse createResponse() {
                try {
                    HttpServletResponse res = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
                    Mockito.when((Object)res.getWriter()).thenReturn((Object)this.writer);
                    return res;
                }
                catch (Exception e) {
                    throw new WebAppException((Throwable)e);
                }
            }
        }});
    }

    public static <T> Injector createMockInjector(T impl) {
        return WebAppTests.createMockInjector(impl.getClass(), impl, new Module[0]);
    }

    public static void flushOutput(Injector injector) {
        HttpServletResponse res = (HttpServletResponse)injector.getInstance(HttpServletResponse.class);
        try {
            res.getWriter().flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Injector testController(Class<? extends Controller> ctrlr, String methodName, Class<T> api, T impl, Module ... modules) {
        try {
            Injector injector = WebAppTests.createMockInjector(api, impl, modules);
            Method method = ctrlr.getMethod(methodName, null);
            method.invoke(injector.getInstance(ctrlr), (Object[])null);
            return injector;
        }
        catch (Exception e) {
            throw new WebAppException((Throwable)e);
        }
    }

    public static <T> Injector testController(Class<? extends Controller> ctrlr, String methodName) {
        return WebAppTests.testController(ctrlr, methodName, null, null, new Module[0]);
    }

    public static <T> Injector testPage(Class<? extends View> page, Class<T> api, T impl, Map<String, String> params, Module ... modules) {
        Injector injector = WebAppTests.createMockInjector(api, impl, modules);
        View view = (View)injector.getInstance(page);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                view.set(entry.getKey(), entry.getValue());
            }
        }
        view.render();
        WebAppTests.flushOutput(injector);
        return injector;
    }

    public static <T> Injector testPage(Class<? extends View> page, Class<T> api, T impl, Module ... modules) {
        return WebAppTests.testPage(page, api, impl, null, modules);
    }

    public static <T> Injector testPage(Class<? extends View> page) {
        return WebAppTests.testPage(page, null, null, new Module[0]);
    }

    public static <T> Injector testBlock(Class<? extends SubView> block, Class<T> api, T impl, Module ... modules) {
        Injector injector = WebAppTests.createMockInjector(api, impl, modules);
        ((SubView)injector.getInstance(block)).renderPartial();
        WebAppTests.flushOutput(injector);
        return injector;
    }

    public static <T> Injector testBlock(Class<? extends SubView> block) {
        return WebAppTests.testBlock(block, null, null, new Module[0]);
    }

    public static PrintWriter getPrintWriter(Injector injector) throws IOException {
        HttpServletResponse res = (HttpServletResponse)injector.getInstance(HttpServletResponse.class);
        return res.getWriter();
    }
}

