/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerResponsePBImpl;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.junit.Assert;
import org.junit.Test;

public class TestRegisterNodeManagerResponse {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testRoundTrip() throws Exception {
        RegisterNodeManagerResponse resp = (RegisterNodeManagerResponse)recordFactory.newRecordInstance(RegisterNodeManagerResponse.class);
        byte[] b = new byte[]{0, 1, 2, 3, 4, 5};
        MasterKey containerTokenMK = (MasterKey)recordFactory.newRecordInstance(MasterKey.class);
        containerTokenMK.setKeyId(54321);
        containerTokenMK.setBytes(ByteBuffer.wrap(b));
        resp.setContainerTokenMasterKey(containerTokenMK);
        MasterKey nmTokenMK = (MasterKey)recordFactory.newRecordInstance(MasterKey.class);
        nmTokenMK.setKeyId(12345);
        nmTokenMK.setBytes(ByteBuffer.wrap(b));
        resp.setNMTokenMasterKey(nmTokenMK);
        resp.setNodeAction(NodeAction.NORMAL);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)resp.getNodeAction());
        Assert.assertNotNull((Object)resp.getContainerTokenMasterKey());
        Assert.assertEquals((long)54321L, (long)resp.getContainerTokenMasterKey().getKeyId());
        Assert.assertArrayEquals((byte[])b, (byte[])resp.getContainerTokenMasterKey().getBytes().array());
        RegisterNodeManagerResponse respCopy = TestRegisterNodeManagerResponse.serDe(resp);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)respCopy.getNodeAction());
        Assert.assertNotNull((Object)respCopy.getContainerTokenMasterKey());
        Assert.assertEquals((long)54321L, (long)respCopy.getContainerTokenMasterKey().getKeyId());
        Assert.assertArrayEquals((byte[])b, (byte[])respCopy.getContainerTokenMasterKey().getBytes().array());
        Assert.assertNotNull((Object)resp.getNMTokenMasterKey());
        Assert.assertEquals((long)12345L, (long)resp.getNMTokenMasterKey().getKeyId());
        Assert.assertArrayEquals((byte[])b, (byte[])resp.getNMTokenMasterKey().getBytes().array());
        respCopy = TestRegisterNodeManagerResponse.serDe(resp);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)respCopy.getNodeAction());
        Assert.assertNotNull((Object)respCopy.getNMTokenMasterKey());
        Assert.assertEquals((long)12345L, (long)respCopy.getNMTokenMasterKey().getKeyId());
        Assert.assertArrayEquals((byte[])b, (byte[])respCopy.getNMTokenMasterKey().getBytes().array());
    }

    public static RegisterNodeManagerResponse serDe(RegisterNodeManagerResponse orig) throws Exception {
        RegisterNodeManagerResponsePBImpl asPB = (RegisterNodeManagerResponsePBImpl)orig;
        YarnServerCommonServiceProtos.RegisterNodeManagerResponseProto proto = asPB.getProto();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        proto.writeTo((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        YarnServerCommonServiceProtos.RegisterNodeManagerResponseProto.Builder cp = YarnServerCommonServiceProtos.RegisterNodeManagerResponseProto.newBuilder();
        cp.mergeFrom((InputStream)in);
        return new RegisterNodeManagerResponsePBImpl(cp.build());
    }
}

