/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.resolver;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.resolver.DefaultSubClusterResolverImpl;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultSubClusterResolver {
    private static YarnConfiguration conf;
    private static SubClusterResolver resolver;

    public static void setUpGoodFile() {
        conf = new YarnConfiguration();
        resolver = new DefaultSubClusterResolverImpl();
        URL url = Thread.currentThread().getContextClassLoader().getResource("nodes");
        if (url == null) {
            throw new RuntimeException("Could not find 'nodes' dummy file in classpath");
        }
        File file = new File(url.getPath());
        conf.set("yarn.federation.machine-list", file.getPath());
        resolver.setConf((Configuration)conf);
        resolver.load();
    }

    private void setUpMalformedFile() {
        conf = new YarnConfiguration();
        resolver = new DefaultSubClusterResolverImpl();
        URL url = Thread.currentThread().getContextClassLoader().getResource("nodes-malformed");
        if (url == null) {
            throw new RuntimeException("Could not find 'nodes-malformed' dummy file in classpath");
        }
        File file = new File(url.getPath());
        conf.set("yarn.federation.machine-list", file.getPath());
        resolver.setConf((Configuration)conf);
        resolver.load();
    }

    private void setUpNonExistentFile() {
        conf = new YarnConfiguration();
        resolver = new DefaultSubClusterResolverImpl();
        conf.set("yarn.federation.machine-list", "fileDoesNotExist");
        resolver.setConf((Configuration)conf);
        resolver.load();
    }

    @Test
    public void testGetSubClusterForNode() throws YarnException {
        TestDefaultSubClusterResolver.setUpGoodFile();
        Assert.assertEquals((Object)SubClusterId.newInstance((String)"subcluster1"), (Object)resolver.getSubClusterForNode("node1"));
        Assert.assertEquals((Object)SubClusterId.newInstance((String)"subcluster2"), (Object)resolver.getSubClusterForNode("node2"));
        Assert.assertEquals((Object)SubClusterId.newInstance((String)"subcluster3"), (Object)resolver.getSubClusterForNode("node3"));
        try {
            resolver.getSubClusterForNode("nodeDoesNotExist");
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot find subClusterId for node"));
        }
    }

    @Test
    public void testGetSubClusterForNodeMalformedFile() throws YarnException {
        this.setUpMalformedFile();
        try {
            resolver.getSubClusterForNode("node1");
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot find subClusterId for node"));
        }
        try {
            resolver.getSubClusterForNode("node2");
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot find subClusterId for node"));
        }
        Assert.assertEquals((Object)SubClusterId.newInstance((String)"subcluster3"), (Object)resolver.getSubClusterForNode("node3"));
        try {
            resolver.getSubClusterForNode("nodeDoesNotExist");
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot find subClusterId for node"));
        }
    }

    @Test
    public void testGetSubClusterForNodeNoFile() throws YarnException {
        this.setUpNonExistentFile();
        try {
            resolver.getSubClusterForNode("node1");
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot find subClusterId for node"));
        }
    }

    @Test
    public void testGetSubClustersForRack() throws YarnException {
        TestDefaultSubClusterResolver.setUpGoodFile();
        HashSet<SubClusterId> rack1Expected = new HashSet<SubClusterId>();
        rack1Expected.add(SubClusterId.newInstance((String)"subcluster1"));
        rack1Expected.add(SubClusterId.newInstance((String)"subcluster2"));
        HashSet<SubClusterId> rack2Expected = new HashSet<SubClusterId>();
        rack2Expected.add(SubClusterId.newInstance((String)"subcluster3"));
        Assert.assertEquals(rack1Expected, (Object)resolver.getSubClustersForRack("rack1"));
        Assert.assertEquals(rack2Expected, (Object)resolver.getSubClustersForRack("rack2"));
        try {
            resolver.getSubClustersForRack("rackDoesNotExist");
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot resolve rack"));
        }
    }

    @Test
    public void testGetSubClustersForRackNoFile() throws YarnException {
        this.setUpNonExistentFile();
        try {
            resolver.getSubClustersForRack("rack1");
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot resolve rack"));
        }
    }
}

