/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.metrics.AMRMClientRelayerMetrics;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAMRMClientRelayerMetrics {
    private Configuration conf;
    private MockApplicationMasterService mockAMS;
    private String homeID = "home";
    private AMRMClientRelayer homeRelayer;
    private String uamID = "uam";
    private AMRMClientRelayer uamRelayer;
    private List<ResourceRequest> asks = new ArrayList<ResourceRequest>();
    private List<ContainerId> releases = new ArrayList<ContainerId>();
    private List<UpdateContainerRequest> updates = new ArrayList<UpdateContainerRequest>();
    private List<String> blacklistAdditions = new ArrayList<String>();
    private List<String> blacklistRemoval = new ArrayList<String>();

    @Before
    public void setup() throws YarnException, IOException {
        this.conf = new Configuration();
        this.mockAMS = new MockApplicationMasterService();
        this.homeRelayer = new AMRMClientRelayer((ApplicationMasterProtocol)this.mockAMS, ApplicationId.newInstance((long)0L, (int)0), this.homeID);
        this.homeRelayer.init(this.conf);
        this.homeRelayer.start();
        this.homeRelayer.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance((String)"", (int)0, (String)""));
        this.uamRelayer = new AMRMClientRelayer((ApplicationMasterProtocol)this.mockAMS, ApplicationId.newInstance((long)0L, (int)0), this.uamID);
        this.uamRelayer.init(this.conf);
        this.uamRelayer.start();
        this.uamRelayer.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance((String)"", (int)0, (String)""));
        this.clearAllocateRequestLists();
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed, 0);
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.homeID, AMRMClientRelayerMetrics.RequestType.Opportunistic, 0);
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.homeID, AMRMClientRelayerMetrics.RequestType.Promote, 0);
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.homeID, AMRMClientRelayerMetrics.RequestType.Demote, 0);
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed, 0);
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.uamID, AMRMClientRelayerMetrics.RequestType.Opportunistic, 0);
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.uamID, AMRMClientRelayerMetrics.RequestType.Promote, 0);
        AMRMClientRelayerMetrics.getInstance().setClientPending(this.uamID, AMRMClientRelayerMetrics.RequestType.Demote, 0);
    }

    private AllocateRequest getAllocateRequest() {
        return AllocateRequest.newBuilder().responseId(0).progress(0.0f).askList(this.asks).releaseList(new ArrayList<ContainerId>(this.releases)).resourceBlacklistRequest(ResourceBlacklistRequest.newInstance(new ArrayList<String>(this.blacklistAdditions), new ArrayList<String>(this.blacklistRemoval))).updateRequests(new ArrayList<UpdateContainerRequest>(this.updates)).build();
    }

    private void clearAllocateRequestLists() {
        this.asks.clear();
        this.releases.clear();
        this.updates.clear();
        this.blacklistAdditions.clear();
        this.blacklistRemoval.clear();
    }

    private static UpdateContainerRequest createPromote(int id) {
        return UpdateContainerRequest.newInstance((int)0, (ContainerId)TestAMRMClientRelayerMetrics.createContainerId(id), (ContainerUpdateType)ContainerUpdateType.PROMOTE_EXECUTION_TYPE, (Resource)Resource.newInstance((int)0, (int)0), (ExecutionType)ExecutionType.GUARANTEED);
    }

    private static UpdateContainerRequest createDemote(int id) {
        return UpdateContainerRequest.newInstance((int)0, (ContainerId)TestAMRMClientRelayerMetrics.createContainerId(id), (ContainerUpdateType)ContainerUpdateType.DEMOTE_EXECUTION_TYPE, (Resource)Resource.newInstance((int)0, (int)0), (ExecutionType)ExecutionType.OPPORTUNISTIC);
    }

    private static ContainerId createContainerId(int id) {
        return ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (long)id);
    }

    public ResourceRequest createResourceRequest(long id, String resource, int memory, int vCores, int priority, ExecutionType execType, int containers) {
        ResourceRequest req = (ResourceRequest)Records.newRecord(ResourceRequest.class);
        req.setAllocationRequestId(id);
        req.setResourceName(resource);
        req.setCapability(Resource.newInstance((int)memory, (int)vCores));
        req.setPriority(Priority.newInstance((int)priority));
        req.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)execType));
        req.setNumContainers(containers);
        return req;
    }

    @Test
    public void testGPending() throws YarnException, IOException {
        this.asks.add(this.createResourceRequest(0L, "node", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "rack", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 2));
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)0L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        this.uamRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        this.asks.get(2).setNumContainers(3);
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)3L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        this.asks.get(2).setNumContainers(2);
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
    }

    @Test
    public void testPromotePending() throws YarnException, IOException {
        this.updates.add(TestAMRMClientRelayerMetrics.createPromote(1));
        this.updates.add(TestAMRMClientRelayerMetrics.createPromote(2));
        this.updates.add(TestAMRMClientRelayerMetrics.createPromote(3));
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)3L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Promote).value());
        this.updates.remove(TestAMRMClientRelayerMetrics.createPromote(3));
        this.updates.add(TestAMRMClientRelayerMetrics.createDemote(3));
        this.updates.add(TestAMRMClientRelayerMetrics.createDemote(4));
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Promote).value());
        ArrayList<UpdatedContainer> updated = new ArrayList<UpdatedContainer>();
        updated.add(UpdatedContainer.newInstance((ContainerUpdateType)ContainerUpdateType.PROMOTE_EXECUTION_TYPE, (Container)Container.newInstance((ContainerId)TestAMRMClientRelayerMetrics.createContainerId(2), null, null, null, null, null)));
        updated.add(UpdatedContainer.newInstance((ContainerUpdateType)ContainerUpdateType.PROMOTE_EXECUTION_TYPE, (Container)Container.newInstance((ContainerId)TestAMRMClientRelayerMetrics.createContainerId(5), null, null, null, null, null)));
        this.mockAMS.response.setUpdatedContainers(updated);
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)1L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Promote).value());
        this.mockAMS.response.getUpdatedContainers().clear();
        this.updates.remove(TestAMRMClientRelayerMetrics.createPromote(2));
        ArrayList<ContainerStatus> completed = new ArrayList<ContainerStatus>();
        completed.add(ContainerStatus.newInstance((ContainerId)TestAMRMClientRelayerMetrics.createContainerId(1), null, (String)"", (int)0));
        completed.add(ContainerStatus.newInstance((ContainerId)TestAMRMClientRelayerMetrics.createContainerId(6), null, (String)"", (int)0));
        this.mockAMS.response.setCompletedContainersStatuses(completed);
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)0L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Promote).value());
    }

    @Test
    public void testCleanUpOnFinish() throws YarnException, IOException {
        this.asks.add(this.createResourceRequest(0L, "node", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "rack", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 2));
        this.updates.add(TestAMRMClientRelayerMetrics.createPromote(1));
        this.updates.add(TestAMRMClientRelayerMetrics.createPromote(2));
        this.updates.add(TestAMRMClientRelayerMetrics.createPromote(3));
        this.homeRelayer.allocate(this.getAllocateRequest());
        this.homeRelayer.shutdown();
        Assert.assertEquals((long)0L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)0L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Promote).value());
    }

    @Test
    public void testFailover() throws YarnException, IOException {
        this.asks.add(this.createResourceRequest(0L, "node", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "rack", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 2));
        long previousSuccess = AMRMClientRelayerMetrics.getInstance().getHeartbeatSuccessMetric(this.homeID).value();
        long previousFailover = AMRMClientRelayerMetrics.getInstance().getRMMasterSlaveSwitchMetric(this.homeID).value();
        this.mockAMS.failover = true;
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)(++previousFailover), (long)AMRMClientRelayerMetrics.getInstance().getRMMasterSlaveSwitchMetric(this.homeID).value());
        Assert.assertEquals((long)(++previousSuccess), (long)AMRMClientRelayerMetrics.getInstance().getHeartbeatSuccessMetric(this.homeID).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)0L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        this.uamRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        this.asks.get(2).setNumContainers(3);
        this.mockAMS.failover = true;
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)(++previousFailover), (long)AMRMClientRelayerMetrics.getInstance().getRMMasterSlaveSwitchMetric(this.homeID).value());
        Assert.assertEquals((long)(++previousSuccess), (long)AMRMClientRelayerMetrics.getInstance().getHeartbeatSuccessMetric(this.homeID).value());
        Assert.assertEquals((long)3L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        this.asks.get(2).setNumContainers(2);
        this.mockAMS.failover = true;
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)(++previousFailover), (long)AMRMClientRelayerMetrics.getInstance().getRMMasterSlaveSwitchMetric(this.homeID).value());
        Assert.assertEquals((long)(++previousSuccess), (long)AMRMClientRelayerMetrics.getInstance().getHeartbeatSuccessMetric(this.homeID).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)2L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        long previousFailure = AMRMClientRelayerMetrics.getInstance().getHeartbeatFailureMetric(this.homeID).value();
        this.mockAMS.exception = true;
        try {
            this.homeRelayer.allocate(this.getAllocateRequest());
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        Assert.assertEquals((long)previousFailover, (long)AMRMClientRelayerMetrics.getInstance().getRMMasterSlaveSwitchMetric(this.homeID).value());
        Assert.assertEquals((long)previousSuccess, (long)AMRMClientRelayerMetrics.getInstance().getHeartbeatSuccessMetric(this.homeID).value());
        Assert.assertEquals((long)(++previousFailure), (long)AMRMClientRelayerMetrics.getInstance().getHeartbeatFailureMetric(this.homeID).value());
        this.mockAMS.failover = true;
        this.mockAMS.exception = true;
        try {
            this.homeRelayer.allocate(this.getAllocateRequest());
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        Assert.assertEquals((long)(++previousFailover), (long)AMRMClientRelayerMetrics.getInstance().getRMMasterSlaveSwitchMetric(this.homeID).value());
        Assert.assertEquals((long)previousSuccess, (long)AMRMClientRelayerMetrics.getInstance().getHeartbeatSuccessMetric(this.homeID).value());
        Assert.assertEquals((long)(++previousFailure), (long)AMRMClientRelayerMetrics.getInstance().getHeartbeatFailureMetric(this.homeID).value());
    }

    @Test
    public void testNewEmptyRequest() throws YarnException, IOException {
        this.asks.add(this.createResourceRequest(1L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 0));
        this.homeRelayer.allocate(this.getAllocateRequest());
        Assert.assertEquals((long)0L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.homeID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
        Assert.assertEquals((long)0L, (long)AMRMClientRelayerMetrics.getInstance().getPendingMetric(this.uamID, AMRMClientRelayerMetrics.RequestType.Guaranteed).value());
    }

    public static class MockApplicationMasterService
    implements ApplicationMasterProtocol {
        private boolean failover = false;
        private boolean exception = false;
        private List<ResourceRequest> lastAsk;
        private List<ContainerId> lastRelease;
        private List<UpdateContainerRequest> lastUpdates;
        private List<String> lastBlacklistAdditions;
        private List<String> lastBlacklistRemovals;
        private AllocateResponse response = AllocateResponse.newInstance((int)0, null, null, new ArrayList(), (Resource)Resource.newInstance((int)0, (int)0), null, (int)0, null, null);

        public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
            return null;
        }

        public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
            if (this.failover) {
                this.failover = false;
                throw new ApplicationMasterNotRegisteredException("Mock RM restarted");
            }
            return null;
        }

        public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
            if (this.failover) {
                this.failover = false;
                throw new ApplicationMasterNotRegisteredException("Mock RM restarted");
            }
            if (this.exception) {
                this.exception = false;
                throw new YarnException("Mock RM encountered exception");
            }
            this.lastAsk = request.getAskList();
            this.lastRelease = request.getReleaseList();
            this.lastUpdates = request.getUpdateRequests();
            this.lastBlacklistAdditions = request.getResourceBlacklistRequest().getBlacklistAdditions();
            this.lastBlacklistRemovals = request.getResourceBlacklistRequest().getBlacklistRemovals();
            return this.response;
        }

        public void setFailoverFlag() {
            this.failover = true;
        }
    }
}

