/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.uam;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.MockResourceManagerFacade;
import org.apache.hadoop.yarn.server.uam.UnmanagedApplicationManager;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUnmanagedApplicationManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestUnmanagedApplicationManager.class);
    private TestableUnmanagedApplicationManager uam;
    private Configuration conf = new YarnConfiguration();
    private CountingCallback callback;
    private ApplicationAttemptId attemptId;

    @Before
    public void setup() {
        this.conf.set("yarn.resourcemanager.cluster-id", "subclusterId");
        this.callback = new CountingCallback();
        this.attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.uam = new TestableUnmanagedApplicationManager(this.conf, this.attemptId.getApplicationId(), null, "submitter", "appNameSuffix", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCallBackCountAndCheckZeroPending(CountingCallback callBack, int expectCallBackCount) {
        CountingCallback countingCallback = callBack;
        synchronized (countingCallback) {
            while (callBack.callBackCount != expectCallBackCount) {
                try {
                    callBack.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Assert.assertEquals((String)("Non zero pending requests when number of allocate callbacks reaches " + expectCallBackCount), (long)0L, (long)callBack.requestQueueSize);
        }
    }

    @Test(timeout=5000L)
    public void testBasicUsage() throws YarnException, IOException, InterruptedException {
        this.launchUAM(this.attemptId);
        this.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance(null, (int)0, null), this.attemptId);
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        this.waitForCallBackCountAndCheckZeroPending(this.callback, 1);
        this.finishApplicationMaster(FinishApplicationMasterRequest.newInstance(null, null, null), this.attemptId);
    }

    @Test(timeout=5000L)
    public void testUAMReAttach() throws YarnException, IOException, InterruptedException {
        this.launchUAM(this.attemptId);
        this.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance(null, (int)0, null), this.attemptId);
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        this.waitForCallBackCountAndCheckZeroPending(this.callback, 1);
        MockResourceManagerFacade rmProxy = this.uam.getRMProxy();
        this.uam = new TestableUnmanagedApplicationManager(this.conf, this.attemptId.getApplicationId(), null, "submitter", "appNameSuffix", true);
        this.uam.setRMProxy(rmProxy);
        this.reAttachUAM(null, this.attemptId);
        this.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance(null, (int)0, null), this.attemptId);
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        this.waitForCallBackCountAndCheckZeroPending(this.callback, 2);
        this.finishApplicationMaster(FinishApplicationMasterRequest.newInstance(null, null, null), this.attemptId);
    }

    @Test(timeout=5000L)
    public void testReRegister() throws YarnException, IOException, InterruptedException {
        this.launchUAM(this.attemptId);
        this.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance(null, (int)0, null), this.attemptId);
        this.uam.setShouldReRegisterNext();
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        this.waitForCallBackCountAndCheckZeroPending(this.callback, 1);
        this.uam.setShouldReRegisterNext();
        this.finishApplicationMaster(FinishApplicationMasterRequest.newInstance(null, null, null), this.attemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSlowRegisterCall() throws YarnException, IOException, InterruptedException {
        Object syncObj;
        Thread registerAMThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestUnmanagedApplicationManager.this.launchUAM(TestUnmanagedApplicationManager.this.attemptId);
                    TestUnmanagedApplicationManager.this.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance(null, (int)1001, null), TestUnmanagedApplicationManager.this.attemptId);
                }
                catch (Exception e) {
                    LOG.info("Register thread exception", (Throwable)e);
                }
            }
        });
        Object object = syncObj = MockResourceManagerFacade.getSyncObj();
        synchronized (object) {
            LOG.info("Starting register thread");
            registerAMThread.start();
            try {
                LOG.info("Test main starts waiting");
                syncObj.wait();
                LOG.info("Test main wait finished");
            }
            catch (Exception e) {
                LOG.info("Test main wait interrupted", (Throwable)e);
            }
        }
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        object = syncObj;
        synchronized (object) {
            syncObj.notifyAll();
        }
        LOG.info("Test main wait for register thread to finish");
        registerAMThread.join();
        LOG.info("Register thread finished");
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        this.waitForCallBackCountAndCheckZeroPending(this.callback, 2);
        this.finishApplicationMaster(FinishApplicationMasterRequest.newInstance(null, null, null), this.attemptId);
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
        Assert.assertEquals((long)0L, (long)this.callback.requestQueueSize);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)this.callback.callBackCount);
    }

    @Test(expected=Exception.class)
    public void testAllocateWithoutRegister() throws YarnException, IOException, InterruptedException {
        this.allocateAsync(AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null), this.callback, this.attemptId);
    }

    @Test(expected=Exception.class)
    public void testFinishWithoutRegister() throws YarnException, IOException, InterruptedException {
        this.finishApplicationMaster(FinishApplicationMasterRequest.newInstance(null, null, null), this.attemptId);
    }

    @Test
    public void testForceKill() throws YarnException, IOException, InterruptedException {
        this.launchUAM(this.attemptId);
        this.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance(null, (int)0, null), this.attemptId);
        this.uam.forceKillApplication();
        try {
            this.uam.forceKillApplication();
            Assert.fail((String)"Should fail because application is already killed");
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
    }

    protected UserGroupInformation getUGIWithToken(ApplicationAttemptId appAttemptId) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)appAttemptId.toString());
        AMRMTokenIdentifier token = new AMRMTokenIdentifier(appAttemptId, 1);
        ugi.addTokenIdentifier((TokenIdentifier)token);
        return ugi;
    }

    protected Token<AMRMTokenIdentifier> launchUAM(ApplicationAttemptId appAttemptId) throws IOException, InterruptedException {
        return (Token)this.getUGIWithToken(appAttemptId).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<AMRMTokenIdentifier>>(){

            @Override
            public Token<AMRMTokenIdentifier> run() throws Exception {
                return TestUnmanagedApplicationManager.this.uam.launchUAM();
            }
        });
    }

    protected void reAttachUAM(final Token<AMRMTokenIdentifier> uamToken, ApplicationAttemptId appAttemptId) throws IOException, InterruptedException {
        this.getUGIWithToken(appAttemptId).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Token<AMRMTokenIdentifier> run() throws Exception {
                TestUnmanagedApplicationManager.this.uam.reAttachUAM(uamToken);
                return null;
            }
        });
    }

    protected RegisterApplicationMasterResponse registerApplicationMaster(final RegisterApplicationMasterRequest request, ApplicationAttemptId appAttemptId) throws YarnException, IOException, InterruptedException {
        return (RegisterApplicationMasterResponse)this.getUGIWithToken(appAttemptId).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RegisterApplicationMasterResponse>(){

            @Override
            public RegisterApplicationMasterResponse run() throws YarnException, IOException {
                return TestUnmanagedApplicationManager.this.uam.registerApplicationMaster(request);
            }
        });
    }

    protected void allocateAsync(final AllocateRequest request, final AsyncCallback<AllocateResponse> callBack, ApplicationAttemptId appAttemptId) throws YarnException, IOException, InterruptedException {
        this.getUGIWithToken(appAttemptId).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws YarnException {
                TestUnmanagedApplicationManager.this.uam.allocateAsync(request, callBack);
                return null;
            }
        });
    }

    protected FinishApplicationMasterResponse finishApplicationMaster(final FinishApplicationMasterRequest request, ApplicationAttemptId appAttemptId) throws YarnException, IOException, InterruptedException {
        return (FinishApplicationMasterResponse)this.getUGIWithToken(appAttemptId).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FinishApplicationMasterResponse>(){

            @Override
            public FinishApplicationMasterResponse run() throws YarnException, IOException {
                FinishApplicationMasterResponse response = TestUnmanagedApplicationManager.this.uam.finishApplicationMaster(request);
                return response;
            }
        });
    }

    public static class TestableUnmanagedApplicationManager
    extends UnmanagedApplicationManager {
        private MockResourceManagerFacade rmProxy;

        public TestableUnmanagedApplicationManager(Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts) {
            super(conf, appId, queueName, submitter, appNameSuffix, keepContainersAcrossApplicationAttempts, "TEST");
        }

        protected <T> T createRMProxy(Class<T> protocol, Configuration config, UserGroupInformation user, Token<AMRMTokenIdentifier> token) {
            if (this.rmProxy == null) {
                this.rmProxy = new MockResourceManagerFacade(config, 0);
            }
            return (T)this.rmProxy;
        }

        public void setShouldReRegisterNext() {
            if (this.rmProxy != null) {
                this.rmProxy.setShouldReRegisterNext();
            }
        }

        public MockResourceManagerFacade getRMProxy() {
            return this.rmProxy;
        }

        public void setRMProxy(MockResourceManagerFacade proxy) {
            this.rmProxy = proxy;
        }
    }

    protected class CountingCallback
    implements AsyncCallback<AllocateResponse> {
        private int callBackCount;
        private int requestQueueSize;

        protected CountingCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(AllocateResponse response) {
            CountingCallback countingCallback = this;
            synchronized (countingCallback) {
                ++this.callBackCount;
                this.requestQueueSize = TestUnmanagedApplicationManager.this.uam.getRequestQueueSize();
                this.notifyAll();
            }
        }
    }
}

