/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.webapp.ContainerBlock;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.webapp.View;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ContainerBlockTest {
    private void initResourceTypes(String resourceName) {
        CustomResourceTypesConfigurationProvider.resourceName = resourceName;
        Configuration configuration = new Configuration();
        configuration.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
        ResourceUtils.resetResourceTypes((Configuration)configuration);
    }

    private ContainerReport createContainerReport() {
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        ContainerReport container = ContainerReport.newInstance((ContainerId)containerId, null, (NodeId)NodeId.newInstance((String)"host", (int)1234), (Priority)Priority.UNDEFINED, (long)1234L, (long)5678L, (String)"diagnosticInfo", (String)"logURL", (int)0, (ContainerState)ContainerState.COMPLETE, (String)("http://" + NodeId.newInstance((String)"host", (int)2345).toString()));
        return container;
    }

    @Test
    public void testRenderResourcesString() {
        this.initResourceTypes("yarn.io/gpu");
        Resource resource = ResourceTypesTestHelper.newResource((long)8192L, (int)4, (Map)ImmutableMap.builder().put((Object)"yarn.io/gpu", (Object)"5").build());
        ContainerBlock block = new ContainerBlock((ApplicationBaseProtocol)Mockito.mock(ApplicationBaseProtocol.class), (View.ViewContext)Mockito.mock(View.ViewContext.class));
        ContainerReport containerReport = this.createContainerReport();
        containerReport.setAllocatedResource(resource);
        ContainerInfo containerInfo = new ContainerInfo(containerReport);
        String resources = block.getResources(containerInfo);
        Assert.assertEquals((Object)"8192 Memory, 4 VCores, 5 yarn.io/gpu", (Object)resources);
    }

    private static class CustomResourceTypesConfigurationProvider
    extends LocalConfigurationProvider {
        private static String resourceName;

        private CustomResourceTypesConfigurationProvider() {
        }

        public InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws YarnException, IOException {
            if ("resource-types.xml".equals(name)) {
                return new ByteArrayInputStream(("<configuration>\n <property>\n   <name>yarn.resource-types</name>\n   <value>" + resourceName + "</value>\n </property>\n <property>\n   <name>yarn.resource-types.a-custom-resource.units</name>\n   <value>G</value>\n </property>\n</configuration>\n").getBytes());
            }
            return super.getConfigurationInputStream(bootstrapConf, name);
        }

        public static String getResourceName() {
            return resourceName;
        }
    }
}

