/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.webapp.LogWebService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLogWebService {
    private HttpServletRequest request;
    private LogWebServiceTest logWebService;
    private static TimelineEntity entity;
    private ApplicationId appId;
    private ContainerId cId;
    private String user = "user1";
    private Map<String, TimelineEntity> entities;
    private String nodeHttpAddress = "localhost:0";

    @Before
    public void setup() throws Exception {
        this.appId = ApplicationId.fromString((String)"application_1518143905142_509690");
        this.cId = ContainerId.fromString((String)"container_e138_1518143905142_509690_01_000001");
        this.entities = new HashMap<String, TimelineEntity>();
        this.generateEntity();
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)System.getProperty("user.name"));
        this.logWebService = new LogWebServiceTest();
    }

    @Test
    public void testGetApp() {
        LogWebService.AppInfo app = this.logWebService.getApp(this.request, this.appId.toString(), null);
        Assert.assertEquals((Object)"RUNNING", (Object)app.getAppState().toString());
        Assert.assertEquals((Object)this.user, (Object)app.getUser());
    }

    @Test
    public void testGetContainer() {
        LogWebService.ContainerInfo container = this.logWebService.getContainer(this.request, this.appId.toString(), this.cId.toString(), null);
        Assert.assertEquals((Object)this.nodeHttpAddress, (Object)container.getNodeHttpAddress());
    }

    private void generateEntity() {
        this.createAppEntities();
        this.createContainerEntities();
    }

    private void createContainerEntities() {
        TimelineEntity timelineEntity = this.generateEntity(TimelineEntityType.YARN_APPLICATION.toString(), this.appId.toString());
        timelineEntity.addInfo("YARN_APPLICATION_USER", (Object)this.user);
        timelineEntity.addInfo("YARN_APPLICATION_STATE", (Object)"RUNNING");
        this.entities.put(this.appId.toString(), timelineEntity);
    }

    private void createAppEntities() {
        TimelineEntity timelineEntity = this.generateEntity(TimelineEntityType.YARN_CONTAINER.toString(), this.cId.toString());
        timelineEntity.addInfo("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS", (Object)this.nodeHttpAddress);
        this.entities.put(this.cId.toString(), timelineEntity);
    }

    private TimelineEntity generateEntity(String entityType, String entityId) {
        TimelineEntity timelineEntity = new TimelineEntity();
        timelineEntity.setId(entityId);
        timelineEntity.setType(entityType);
        timelineEntity.setCreatedTime(Long.valueOf(System.currentTimeMillis()));
        return timelineEntity;
    }

    class LogWebServiceTest
    extends LogWebService {
        LogWebServiceTest() {
        }

        protected TimelineEntity getEntity(String path, MultivaluedMap<String, String> params) throws IOException {
            if (path.endsWith(TestLogWebService.this.cId.toString())) {
                return (TimelineEntity)TestLogWebService.this.entities.get(TestLogWebService.this.cId.toString());
            }
            if (path.endsWith(TestLogWebService.this.appId.toString())) {
                return (TimelineEntity)TestLogWebService.this.entities.get(TestLogWebService.this.appId.toString());
            }
            throw new IOException();
        }
    }
}

