/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;

@Metrics(about="Aggregated metrics of TimelineCollector's running on each NM", context="timelineservice")
public final class PerNodeAggTimelineCollectorMetrics {
    private static final MetricsInfo METRICS_INFO = Interns.info((String)"PerNodeAggTimelineCollectorMetrics", (String)"Aggregated Metrics for TimelineCollector's running on each NM");
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static PerNodeAggTimelineCollectorMetrics instance = null;
    @Metric(about="PUT entities failure latency", valueName="latency")
    private MutableQuantiles putEntitiesFailureLatency;
    @Metric(about="PUT entities success latency", valueName="latency")
    private MutableQuantiles putEntitiesSuccessLatency;
    @Metric(about="async PUT entities failure latency", valueName="latency")
    private MutableQuantiles asyncPutEntitiesFailureLatency;
    @Metric(about="async PUT entities success latency", valueName="latency")
    private MutableQuantiles asyncPutEntitiesSuccessLatency;

    private PerNodeAggTimelineCollectorMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PerNodeAggTimelineCollectorMetrics getInstance() {
        if (isInitialized.get()) return instance;
        Class<PerNodeAggTimelineCollectorMetrics> clazz = PerNodeAggTimelineCollectorMetrics.class;
        synchronized (PerNodeAggTimelineCollectorMetrics.class) {
            if (instance != null) return instance;
            instance = (PerNodeAggTimelineCollectorMetrics)DefaultMetricsSystem.initialize((String)"TimelineService").register(METRICS_INFO.name(), METRICS_INFO.description(), (Object)new PerNodeAggTimelineCollectorMetrics());
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void destroy() {
        isInitialized.set(false);
        instance = null;
    }

    @VisibleForTesting
    public MutableQuantiles getPutEntitiesSuccessLatency() {
        return this.putEntitiesSuccessLatency;
    }

    @VisibleForTesting
    public MutableQuantiles getPutEntitiesFailureLatency() {
        return this.putEntitiesFailureLatency;
    }

    @VisibleForTesting
    public MutableQuantiles getAsyncPutEntitiesSuccessLatency() {
        return this.asyncPutEntitiesSuccessLatency;
    }

    @VisibleForTesting
    public MutableQuantiles getAsyncPutEntitiesFailureLatency() {
        return this.asyncPutEntitiesFailureLatency;
    }

    public void addPutEntitiesLatency(long durationMs, boolean succeeded) {
        if (succeeded) {
            this.putEntitiesSuccessLatency.add(durationMs);
        } else {
            this.putEntitiesFailureLatency.add(durationMs);
        }
    }

    public void addAsyncPutEntitiesLatency(long durationMs, boolean succeeded) {
        if (succeeded) {
            this.asyncPutEntitiesSuccessLatency.add(durationMs);
        } else {
            this.asyncPutEntitiesFailureLatency.add(durationMs);
        }
    }
}

