/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSecureAmFilter {
    private String proxyHost = "localhost";
    private static final File TEST_ROOT_DIR = new File("target", TestSecureAmFilter.class.getName() + "-root");
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static Configuration rmconf = new Configuration();
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static boolean miniKDCStarted = false;
    private static MiniKdc testMiniKDC;

    @BeforeClass
    public static void setUp() {
        rmconf.setBoolean("yarn.acl.enable", true);
        rmconf.set("hadoop.security.authentication", "kerberos");
        rmconf.setBoolean("yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled", true);
        rmconf.set("hadoop.http.filter.initializers", RMAuthenticationFilterInitializer.class.getName());
        rmconf.set("yarn.resourcemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        rmconf.set("yarn.resourcemanager.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set("yarn.resourcemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        UserGroupInformation.setConfiguration((Configuration)rmconf);
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), TEST_ROOT_DIR);
            TestSecureAmFilter.setupKDC();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't create MiniKDC", (boolean)false);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
    }

    private static void setupKDC() throws Exception {
        if (!miniKDCStarted) {
            testMiniKDC.start();
            TestSecureAmFilter.getKdc().createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost"});
            miniKDCStarted = true;
        }
    }

    private static MiniKdc getKdc() {
        return testMiniKDC;
    }

    @Test
    public void testFindRedirectUrl() throws Exception {
        String rm1 = "rm1";
        String rm2 = "rm2";
        String rm1Url = this.startSecureHttpServer();
        String rm2Url = "host2:8088";
        TestAmIpFilter filter = new TestAmIpFilter();
        TestAmIpFilter spy = (TestAmIpFilter)((Object)Mockito.spy((Object)((Object)filter)));
        spy.proxyUriBases = new HashMap();
        spy.proxyUriBases.put("rm1", rm1Url);
        spy.proxyUriBases.put("rm2", "host2:8088");
        spy.rmUrls = new String[]{"rm1", "rm2"};
        Assert.assertTrue((boolean)spy.isValidUrl(rm1Url));
        Assert.assertFalse((boolean)spy.isValidUrl("host2:8088"));
        Assert.assertEquals((Object)spy.findRedirectUrl(), (Object)rm1Url);
    }

    private String startSecureHttpServer() throws Exception {
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("test").setConf(rmconf).addEndpoint(new URI("http://localhost")).setACL(new AccessControlList(rmconf.get("yarn.admin.acl", "*")));
        builder.setUsernameConfKey("yarn.resourcemanager.webapp.spnego-principal").setKeytabConfKey("yarn.resourcemanager.webapp.spnego-keytab-file").setSecurityEnabled(UserGroupInformation.isSecurityEnabled());
        HttpServer2 server = builder.build();
        server.start();
        URL baseUrl = new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        return baseUrl.toString();
    }

    private class TestAmIpFilter
    extends AmIpFilter {
        private Set<String> proxyAddresses = null;

        private TestAmIpFilter() {
        }

        protected Set<String> getProxyAddresses() {
            if (this.proxyAddresses == null) {
                this.proxyAddresses = new HashSet<String>();
            }
            this.proxyAddresses.add(TestSecureAmFilter.this.proxyHost);
            return this.proxyAddresses;
        }
    }
}

