/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.client.ApiServiceClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestApiServiceClient {
    private static ApiServiceClient asc;
    private static ApiServiceClient badAsc;
    private static Server server;

    @BeforeClass
    public static void setup() throws Exception {
        server = new Server(8088);
        ((QueuedThreadPool)server.getThreadPool()).setMaxThreads(10);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/app");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(TestServlet.class), "/*");
        ((ServerConnector)server.getConnectors()[0]).setHost("localhost");
        server.start();
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.webapp.address", "localhost:8088");
        asc = new ApiServiceClient();
        asc.serviceInit(conf);
        Configuration conf2 = new Configuration();
        conf2.set("yarn.resourcemanager.webapp.address", "localhost:8089");
        badAsc = new ApiServiceClient();
        badAsc.serviceInit(conf2);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        server.stop();
    }

    @Test
    public void testLaunch() {
        String fileName = "target/test-classes/example-app.json";
        String appName = "example-app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = asc.actionLaunch(fileName, appName, Long.valueOf(lifetime), queue);
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testBadLaunch() {
        String fileName = "unknown_file";
        String appName = "unknown_app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = badAsc.actionLaunch(fileName, appName, Long.valueOf(lifetime), queue);
            Assert.assertEquals((long)56L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStatus() {
        String appName = "nonexistent-app";
        try {
            String result = asc.getStatusString(appName);
            Assert.assertEquals((String)"Status reponse don't match", (Object)(" Service " + appName + " not found"), (Object)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStop() {
        String appName = "example-app";
        try {
            int result = asc.actionStop(appName);
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testBadStop() {
        String appName = "unknown_app";
        try {
            int result = badAsc.actionStop(appName);
            Assert.assertEquals((long)56L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStart() {
        String appName = "example-app";
        try {
            int result = asc.actionStart(appName);
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testBadStart() {
        String appName = "unknown_app";
        try {
            int result = badAsc.actionStart(appName);
            Assert.assertEquals((long)56L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testSave() {
        String fileName = "target/test-classes/example-app.json";
        String appName = "example-app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = asc.actionSave(fileName, appName, Long.valueOf(lifetime), queue);
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testBadSave() {
        String fileName = "unknown_file";
        String appName = "unknown_app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = badAsc.actionSave(fileName, appName, Long.valueOf(lifetime), queue);
            Assert.assertEquals((long)56L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testFlex() {
        String appName = "example-app";
        HashMap componentCounts = new HashMap();
        try {
            int result = asc.actionFlex(appName, componentCounts);
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testBadFlex() {
        String appName = "unknown_app";
        HashMap componentCounts = new HashMap();
        try {
            int result = badAsc.actionFlex(appName, componentCounts);
            Assert.assertEquals((long)56L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testDestroy() {
        String appName = "example-app";
        try {
            int result = asc.actionDestroy(appName);
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testBadDestroy() {
        String appName = "unknown_app";
        try {
            int result = badAsc.actionDestroy(appName);
            Assert.assertEquals((long)56L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testInitiateServiceUpgrade() {
        String appName = "example-app";
        String upgradeFileName = "target/test-classes/example-app.json";
        try {
            int result = asc.initiateUpgrade(appName, upgradeFileName, false);
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testInstancesUpgrade() {
        String appName = "example-app";
        try {
            int result = asc.actionUpgradeInstances(appName, (List)Lists.newArrayList((Object[])new String[]{"comp-1", "comp-2"}));
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    @Test
    public void testComponentsUpgrade() {
        String appName = "example-app";
        try {
            int result = asc.actionUpgradeComponents(appName, (List)Lists.newArrayList((Object[])new String[]{"comp"}));
            Assert.assertEquals((long)0L, (long)result);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            System.out.println("Get was called");
            if (req.getPathInfo() != null && req.getPathInfo().contains("nonexistent-app")) {
                resp.setStatus(404);
            } else {
                resp.setStatus(200);
            }
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }
    }
}

