/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.service.client.ApiServiceClient;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSecureApiServiceClient
extends KerberosSecurityTestcase {
    private String clientPrincipal = "client";
    private String server1Protocol = "HTTP";
    private String server2Protocol = "server2";
    private String host = "localhost";
    private String server1Principal = this.server1Protocol + "/" + this.host;
    private String server2Principal = this.server2Protocol + "/" + this.host;
    private File keytabFile;
    private Configuration testConf = new Configuration();
    private Map<String, String> props;
    private static Server server;
    private static Logger LOG;
    private ApiServiceClient asc;

    @Before
    public void setUp() throws Exception {
        this.keytabFile = new File(this.getWorkDir(), "keytab");
        this.getKdc().createPrincipal(this.keytabFile, new String[]{this.clientPrincipal, this.server1Principal, this.server2Principal});
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)this.testConf);
        UserGroupInformation.setConfiguration((Configuration)this.testConf);
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        this.props = new HashMap<String, String>();
        this.props.put("javax.security.sasl.qop", SaslRpcServer.QualityOfProtection.AUTHENTICATION.saslQop);
        server = new Server(8088);
        ((QueuedThreadPool)server.getThreadPool()).setMaxThreads(10);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/app");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(TestServlet.class), "/*");
        ((ServerConnector)server.getConnectors()[0]).setHost("localhost");
        server.start();
        final ArrayList<String> rmServers = new ArrayList<String>();
        rmServers.add("localhost:8088");
        this.testConf.set("yarn.resourcemanager.webapp.address", "localhost:8088");
        this.asc = new ApiServiceClient(){

            List<String> getRMHAWebAddresses(Configuration conf) {
                return rmServers;
            }
        };
        this.asc.serviceInit(this.testConf);
    }

    @After
    public void tearDown() throws Exception {
        server.stop();
    }

    @Test
    public void testHttpSpnegoChallenge() throws Exception {
        UserGroupInformation.loginUserFromKeytab((String)this.clientPrincipal, (String)this.keytabFile.getCanonicalPath());
        this.asc = new ApiServiceClient();
        String challenge = this.asc.generateToken("localhost");
        Assert.assertNotNull((Object)challenge);
    }

    @Test
    public void testAuthorizationHeader() throws Exception {
        UserGroupInformation.loginUserFromKeytab((String)this.clientPrincipal, (String)this.keytabFile.getCanonicalPath());
        String rmAddress = this.asc.getRMWebAddress();
        if (TestServlet.isHeaderExist()) {
            Assert.assertEquals((Object)rmAddress, (Object)"http://localhost:8088");
        } else {
            Assert.fail((String)"Did not see Authorization header.");
        }
    }

    static {
        LOG = Logger.getLogger(TestSecureApiServiceClient.class);
    }

    public static class TestServlet
    extends HttpServlet {
        private static boolean headerFound = false;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            Enumeration headers = req.getHeaderNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                LOG.info((Object)header);
            }
            if (req.getHeader("Authorization") != null) {
                headerFound = true;
                resp.setStatus(200);
            } else {
                headerFound = false;
                resp.setStatus(404);
            }
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        public static boolean isHeaderExist() {
            return headerFound;
        }
    }
}

