/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.client.SystemServiceManagerImpl;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSystemServiceManagerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestSystemServiceManagerImpl.class);
    private SystemServiceManagerImpl systemService;
    private Configuration conf;
    private String resourcePath = "system-services";
    private String[] users = new String[]{"user1", "user2"};
    private static Map<String, Set<String>> loadedServices = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> savedServices = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> submittedServices = new HashMap<String, Set<String>>();

    @Before
    public void setup() {
        File file = new File(this.getClass().getClassLoader().getResource(this.resourcePath).getFile());
        this.conf = new Configuration();
        this.conf.set("yarn.service.system-service.dir", file.getAbsolutePath());
        this.systemService = new SystemServiceManagerImpl(){

            ServiceClient getServiceClient() {
                return new TestServiceClient();
            }
        };
        this.systemService.init(this.conf);
        this.constructUserService(this.users[0], "example-app1");
        this.constructUserService(this.users[1], "example-app1", "example-app2");
    }

    @After
    public void tearDown() {
        this.systemService.stop();
    }

    @Test
    public void testSystemServiceSubmission() throws Exception {
        this.systemService.start();
        Map ignoredUserServices = this.systemService.getIgnoredUserServices();
        Assert.assertEquals((long)1L, (long)ignoredUserServices.size());
        Assert.assertTrue((String)"User user1 doesn't exist.", (boolean)ignoredUserServices.containsKey(this.users[0]));
        int count = (Integer)ignoredUserServices.get(this.users[0]);
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((long)1L, (long)this.systemService.getBadFileNameExtensionSkipCounter());
        Assert.assertEquals((long)1L, (long)this.systemService.getBadDirSkipCounter());
        Map userServices = this.systemService.getSyncUserServices();
        Assert.assertEquals((long)loadedServices.size(), (long)userServices.size());
        this.verifyForScannedUserServices(userServices);
        this.verifyForLaunchedUserServices();
        this.systemService.launchUserService(userServices);
        this.verifyForLaunchedUserServices();
        submittedServices.clear();
        this.systemService.launchUserService(userServices);
        this.verifyForLaunchedUserServices();
    }

    private void verifyForScannedUserServices(Map<String, Set<Service>> userServices) {
        for (String user : this.users) {
            Set<Service> services = userServices.get(user);
            Set<String> serviceNames = loadedServices.get(user);
            Assert.assertEquals((long)serviceNames.size(), (long)services.size());
            for (Service next : services) {
                Assert.assertTrue((String)("Service name doesn't exist in expected userService " + serviceNames), (boolean)serviceNames.contains(next.getName()));
            }
        }
    }

    public void constructUserService(String user, String ... serviceNames) {
        Set<String> service = loadedServices.get(user);
        if (service == null) {
            service = new HashSet<String>();
            for (String serviceName : serviceNames) {
                service.add(serviceName);
            }
            loadedServices.put(user, service);
        }
    }

    private void verifyForLaunchedUserServices() {
        Assert.assertEquals((long)loadedServices.size(), (long)submittedServices.size());
        for (Map.Entry<String, Set<String>> entry : submittedServices.entrySet()) {
            String user = entry.getKey();
            Set<String> serviceSet = entry.getValue();
            Assert.assertTrue((boolean)loadedServices.containsKey(user));
            Set<String> services = loadedServices.get(user);
            Assert.assertEquals((long)services.size(), (long)serviceSet.size());
            Assert.assertTrue((boolean)services.containsAll(serviceSet));
        }
    }

    class TestServiceClient
    extends ServiceClient {
        TestServiceClient() {
        }

        protected void serviceStart() throws Exception {
        }

        protected void serviceStop() throws Exception {
        }

        protected void serviceInit(Configuration configuration) throws Exception {
        }

        public int actionBuild(Service service) throws YarnException, IOException {
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            HashSet<String> services = (HashSet<String>)savedServices.get(userName);
            if (services == null) {
                services = new HashSet<String>();
                savedServices.put(userName, services);
            }
            if (services.contains(service.getName())) {
                String message = "Failed to save service " + service.getName() + ", because it already exists.";
                throw new SliderException(75, message);
            }
            services.add(service.getName());
            return 0;
        }

        public ApplicationId actionStartAndGetId(String serviceName) throws YarnException, IOException {
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            HashSet<String> services = (HashSet<String>)submittedServices.get(userName);
            if (services == null) {
                services = new HashSet<String>();
                submittedServices.put(userName, services);
            }
            if (services.contains(serviceName)) {
                String message = "Failed to create service " + serviceName + ", because it is already running.";
                throw new YarnException(message);
            }
            services.add(serviceName);
            return ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        }
    }
}

