/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.service.SystemServiceManager;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemServiceManagerImpl
extends AbstractService
implements SystemServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(SystemServiceManagerImpl.class);
    private static final String YARN_FILE_SUFFIX = ".yarnfile";
    private static final String SYNC = "sync";
    private static final String ASYNC = "async";
    private FileSystem fs;
    private Path systemServiceDir;
    private AtomicBoolean stopExecutors = new AtomicBoolean(false);
    private Map<String, Set<Service>> syncUserServices = new HashMap<String, Set<Service>>();
    private Map<String, Set<Service>> asyncUserServices = new HashMap<String, Set<Service>>();
    private UserGroupInformation loginUGI;
    private Thread serviceLaucher;
    @VisibleForTesting
    private int badFileNameExtensionSkipCounter;
    @VisibleForTesting
    private Map<String, Integer> ignoredUserServices = new HashMap<String, Integer>();
    @VisibleForTesting
    private int badDirSkipCounter;

    public SystemServiceManagerImpl() {
        super(SystemServiceManagerImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String dirPath = conf.get("yarn.service.system-service.dir");
        if (dirPath != null) {
            this.systemServiceDir = new Path(dirPath);
            LOG.info("System Service Directory is configured to {}", (Object)this.systemServiceDir);
            this.fs = this.systemServiceDir.getFileSystem(conf);
            this.loginUGI = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.getLoginUser() : UserGroupInformation.getCurrentUser();
            LOG.info("UserGroupInformation initialized to {}", (Object)this.loginUGI);
        }
    }

    protected void serviceStart() throws Exception {
        this.scanForUserServices();
        this.launchUserService(this.syncUserServices);
        this.serviceLaucher = new Thread(this.createRunnable());
        this.serviceLaucher.setName("System service launcher");
        this.serviceLaucher.start();
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping {}", (Object)this.getName());
        this.stopExecutors.set(true);
        if (this.serviceLaucher != null) {
            this.serviceLaucher.interrupt();
            try {
                this.serviceLaucher.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted Exception while stopping", (Throwable)ie);
            }
        }
    }

    private Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                SystemServiceManagerImpl.this.launchUserService(SystemServiceManagerImpl.this.asyncUserServices);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launchUserService(Map<String, Set<Service>> userServices) {
        for (Map.Entry<String, Set<Service>> entry : userServices.entrySet()) {
            String user = entry.getKey();
            Set<Service> services = entry.getValue();
            if (services.isEmpty()) continue;
            ServiceClient serviceClient = null;
            try {
                UserGroupInformation userUgi = this.getProxyUser(user);
                serviceClient = this.createServiceClient(userUgi);
                for (Service service : services) {
                    LOG.info("POST: createService = {} user = {}", (Object)service, (Object)userUgi);
                    try {
                        this.launchServices(userUgi, serviceClient, service);
                    }
                    catch (IOException | UndeclaredThrowableException e) {
                        if (e.getCause() != null) {
                            LOG.warn(e.getCause().getMessage());
                            continue;
                        }
                        String message = "Failed to create service " + service.getName() + " : ";
                        LOG.error(message, (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.warn("System service launcher thread interrupted", (Throwable)e);
                break;
            }
            catch (Exception e) {
                LOG.error("Error while submitting services for user " + user, (Throwable)e);
            }
            finally {
                if (serviceClient == null) continue;
                try {
                    serviceClient.close();
                }
                catch (IOException e) {
                    LOG.warn("Error while closing serviceClient for user {}", (Object)user);
                }
            }
        }
    }

    private ServiceClient createServiceClient(UserGroupInformation userUgi) throws IOException, InterruptedException {
        ServiceClient serviceClient = (ServiceClient)userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ServiceClient>(){

            @Override
            public ServiceClient run() throws IOException, YarnException {
                ServiceClient sc = SystemServiceManagerImpl.this.getServiceClient();
                sc.init(SystemServiceManagerImpl.this.getConfig());
                sc.start();
                return sc;
            }
        });
        return serviceClient;
    }

    private void launchServices(UserGroupInformation userUgi, final ServiceClient serviceClient, final Service service) throws IOException, InterruptedException {
        if (service.getState() == ServiceState.STOPPED) {
            userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, YarnException {
                    serviceClient.actionBuild(service);
                    return null;
                }
            });
            LOG.info("Service {} version {} saved.", (Object)service.getName(), (Object)service.getVersion());
        } else {
            ApplicationId applicationId = (ApplicationId)userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationId>(){

                @Override
                public ApplicationId run() throws IOException, YarnException {
                    boolean tryStart = true;
                    try {
                        serviceClient.actionBuild(service);
                    }
                    catch (Exception e) {
                        if (e instanceof SliderException && ((SliderException)e).getExitCode() == 75) {
                            LOG.info("Service {} already exists, will attempt to start service", (Object)service.getName());
                        }
                        tryStart = false;
                        LOG.info("Got exception saving {}, will not attempt to start service", (Object)service.getName(), (Object)e);
                    }
                    if (tryStart) {
                        return serviceClient.actionStartAndGetId(service.getName());
                    }
                    return null;
                }
            });
            if (applicationId != null) {
                LOG.info("Service {} submitted with Application ID: {}", (Object)service.getName(), (Object)applicationId);
            }
        }
    }

    ServiceClient getServiceClient() {
        return new ServiceClient();
    }

    private UserGroupInformation getProxyUser(String user) {
        UserGroupInformation ugi = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)this.loginUGI) : UserGroupInformation.createRemoteUser((String)user);
        return ugi;
    }

    void scanForUserServices() throws IOException {
        if (this.systemServiceDir == null) {
            return;
        }
        try {
            LOG.info("Scan for launch type on {}", (Object)this.systemServiceDir);
            RemoteIterator<FileStatus> iterLaunchType = this.list(this.systemServiceDir);
            while (iterLaunchType.hasNext()) {
                FileStatus launchType = (FileStatus)iterLaunchType.next();
                if (!launchType.isDirectory()) {
                    LOG.debug("Scanner skips for unknown file {}", (Object)launchType.getPath());
                    continue;
                }
                if (launchType.getPath().getName().equals(SYNC)) {
                    this.scanForUserServiceDefinition(launchType.getPath(), this.syncUserServices);
                    continue;
                }
                if (launchType.getPath().getName().equals(ASYNC)) {
                    this.scanForUserServiceDefinition(launchType.getPath(), this.asyncUserServices);
                    continue;
                }
                ++this.badDirSkipCounter;
                LOG.debug("Scanner skips for unknown dir {}.", (Object)launchType.getPath());
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("System service directory {} doesn't not exist.", (Object)this.systemServiceDir);
        }
    }

    private void scanForUserServiceDefinition(Path userDirPath, Map<String, Set<Service>> userServices) throws IOException {
        LOG.info("Scan for users on {}", (Object)userDirPath);
        RemoteIterator<FileStatus> iterUsers = this.list(userDirPath);
        while (iterUsers.hasNext()) {
            FileStatus userDir = (FileStatus)iterUsers.next();
            if (!userDir.isDirectory()) {
                LOG.info("Service definition {} doesn't belong to any user. Ignoring.. ", (Object)userDir.getPath().getName());
                continue;
            }
            String userName = userDir.getPath().getName();
            LOG.info("Scanning service definitions for user {}.", (Object)userName);
            RemoteIterator<FileStatus> iterServices = this.list(userDir.getPath());
            while (iterServices.hasNext()) {
                FileStatus serviceCache = (FileStatus)iterServices.next();
                String filename = serviceCache.getPath().getName();
                if (!serviceCache.isFile()) {
                    LOG.info("Scanner skips for unknown dir {}", (Object)filename);
                    continue;
                }
                if (!filename.endsWith(YARN_FILE_SUFFIX)) {
                    LOG.info("Scanner skips for unknown file extension, filename = {}", (Object)filename);
                    ++this.badFileNameExtensionSkipCounter;
                    continue;
                }
                Service service = this.getServiceDefinition(serviceCache.getPath());
                if (service == null) continue;
                Set<Service> services = userServices.get(userName);
                if (services == null) {
                    services = new HashSet<Service>();
                    userServices.put(userName, services);
                }
                if (!services.add(service)) {
                    int count = this.ignoredUserServices.containsKey(userName) ? this.ignoredUserServices.get(userName) : 0;
                    this.ignoredUserServices.put(userName, count + 1);
                    LOG.warn("Ignoring service {} for the user {} as it is already present, filename = {}", new Object[]{service.getName(), userName, filename});
                    continue;
                }
                LOG.info("Added service {} for the user {}, filename = {}", new Object[]{service.getName(), userName, filename});
            }
        }
    }

    private Service getServiceDefinition(Path filePath) {
        Service service = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading service definition from FS: " + filePath);
            }
            service = (Service)ServiceApiUtil.jsonSerDeser.load(this.fs, filePath);
        }
        catch (IOException e) {
            LOG.info("Error while loading service definition from FS: {}", (Throwable)e);
        }
        return service;
    }

    private RemoteIterator<FileStatus> list(Path path) throws IOException {
        return new StoppableRemoteIterator((RemoteIterator<FileStatus>)this.fs.listStatusIterator(path));
    }

    @VisibleForTesting
    Map<String, Integer> getIgnoredUserServices() {
        return this.ignoredUserServices;
    }

    @VisibleForTesting
    Map<String, Set<Service>> getSyncUserServices() {
        return this.syncUserServices;
    }

    @VisibleForTesting
    int getBadFileNameExtensionSkipCounter() {
        return this.badFileNameExtensionSkipCounter;
    }

    @VisibleForTesting
    int getBadDirSkipCounter() {
        return this.badDirSkipCounter;
    }

    private class StoppableRemoteIterator
    implements RemoteIterator<FileStatus> {
        private final RemoteIterator<FileStatus> remote;

        StoppableRemoteIterator(RemoteIterator<FileStatus> remote) {
            this.remote = remote;
        }

        public boolean hasNext() throws IOException {
            return !SystemServiceManagerImpl.this.stopExecutors.get() && this.remote.hasNext();
        }

        public FileStatus next() throws IOException {
            return (FileStatus)this.remote.next();
        }
    }
}

