/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.param.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.exception.SubmarineRuntimeException;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CliUtils.class);
    private static final String RES_PATTERN = "^[^=]+=\\d+\\s?\\w*$";

    public static String replacePatternsInLaunchCommand(String specifiedCli, RunJobParameters jobRunParameters, RemoteDirectoryManager directoryManager) throws IOException {
        String input = jobRunParameters.getInputPath();
        String jobDir = jobRunParameters.getCheckpointPath();
        String savedModelDir = jobRunParameters.getSavedModelPath();
        HashMap<String, String> replacePattern = new HashMap<String, String>();
        if (jobDir != null) {
            replacePattern.put("%checkpoint_path%", jobDir);
        }
        if (input != null) {
            replacePattern.put("%input_path%", input);
        }
        if (savedModelDir != null) {
            replacePattern.put("%saved_model_path%", savedModelDir);
        }
        String newCli = specifiedCli;
        for (Map.Entry replace : replacePattern.entrySet()) {
            newCli = newCli.replace((CharSequence)replace.getKey(), (CharSequence)replace.getValue());
        }
        return newCli;
    }

    private static Map<String, Long> parseResourcesString(String resourcesStr) {
        HashMap<String, Long> resources = new HashMap<String, Long>();
        if (resourcesStr.startsWith("[")) {
            resourcesStr = resourcesStr.substring(1);
        }
        if (resourcesStr.endsWith("]")) {
            resourcesStr = resourcesStr.substring(0, resourcesStr.length() - 1);
        }
        for (String resource : resourcesStr.trim().split(",")) {
            if (!(resource = resource.trim()).matches(RES_PATTERN)) {
                throw new IllegalArgumentException("\"" + resource + "\" is not a valid resource type/amount pair. Please provide key=amount pairs separated by commas.");
            }
            String[] splits = resource.split("=");
            String key = splits[0];
            String value = splits[1];
            String units = ResourceUtils.getUnits((String)value);
            String valueWithoutUnit = value.substring(0, value.length() - units.length()).trim();
            Long resourceValue = Long.valueOf(valueWithoutUnit);
            if (units.equals("M") || units.equals("m")) {
                units = "Mi";
            } else if (units.equals("G") || units.equals("g")) {
                units = "Gi";
            } else if (!units.isEmpty()) {
                throw new IllegalArgumentException("Acceptable units are M/G or empty");
            }
            if (key.equals("memory-mb") && !units.isEmpty()) {
                resourceValue = UnitsConversionUtil.convert((String)units, (String)"Mi", (long)resourceValue);
            }
            if (key.equals("memory")) {
                key = "memory-mb";
                resourceValue = UnitsConversionUtil.convert((String)units, (String)"Mi", (long)resourceValue);
            }
            if (key.equals("gpu")) {
                key = "yarn.io/gpu";
            }
            if (key.equals("fpga")) {
                key = "yarn.io/fpga";
            }
            resources.put(key, resourceValue);
        }
        return resources;
    }

    private static void validateResourceTypes(Iterable<String> resourceNames, List<ResourceTypeInfo> resourceTypes) throws IOException, YarnException {
        for (String resourceName : resourceNames) {
            if (resourceTypes.stream().anyMatch(e -> e.getName().equals(resourceName))) continue;
            throw new ResourceNotFoundException("Unknown resource: " + resourceName);
        }
    }

    public static Resource createResourceFromString(String resourceStr, List<ResourceTypeInfo> resourceTypes) throws IOException, YarnException {
        Map<String, Long> typeToValue = CliUtils.parseResourcesString(resourceStr);
        CliUtils.validateResourceTypes(typeToValue.keySet(), resourceTypes);
        Resource resource = Resource.newInstance((int)0, (int)0);
        for (Map.Entry<String, Long> entry : typeToValue.entrySet()) {
            resource.setResourceValue(entry.getKey(), entry.getValue().longValue());
        }
        return resource;
    }

    public static boolean argsForHelp(String[] args) {
        if (args == null || args.length == 0) {
            return true;
        }
        return args.length == 1 && (args[0].equals("-h") || args[0].equals("--help"));
    }

    public static void doLoginIfSecure(String keytab, String principal) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)keytab) || StringUtils.isEmpty((CharSequence)principal)) {
            if (StringUtils.isNotEmpty((CharSequence)keytab)) {
                SubmarineRuntimeException e = new SubmarineRuntimeException("The parameter of principal is missing.");
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            if (StringUtils.isNotEmpty((CharSequence)principal)) {
                SubmarineRuntimeException e = new SubmarineRuntimeException("The parameter of keytab is missing.");
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            UserGroupInformation user = UserGroupInformation.getCurrentUser();
            if (user == null || user.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.SIMPLE) {
                SubmarineRuntimeException e = new SubmarineRuntimeException("Failed to authenticate in secure environment. Please run kinit command in advance or use --keytab/--principal parameters");
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            LOG.info("Submarine job is submitted by user: " + user.getUserName());
            return;
        }
        File keytabFile = new File(keytab);
        if (!keytabFile.exists()) {
            SubmarineRuntimeException e = new SubmarineRuntimeException("No keytab localized at  " + keytab);
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
    }
}

