/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.common;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineConfiguration;
import org.apache.hadoop.yarn.submarine.common.fs.DefaultRemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.RuntimeFactory;

public class ClientContext {
    private Configuration yarnConf = new YarnConfiguration();
    private volatile RemoteDirectoryManager remoteDirectoryManager;
    private YarnClient yarnClient;
    private Configuration submarineConfig = new SubmarineConfiguration();
    private RuntimeFactory runtimeFactory;

    public synchronized YarnClient getOrCreateYarnClient() {
        if (this.yarnClient == null) {
            this.yarnClient = YarnClient.createYarnClient();
            this.yarnClient.init(this.yarnConf);
            this.yarnClient.start();
        }
        return this.yarnClient;
    }

    public Configuration getYarnConfig() {
        return this.yarnConf;
    }

    public void setConfiguration(Configuration conf) {
        this.yarnConf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDirectoryManager getRemoteDirectoryManager() {
        if (this.remoteDirectoryManager == null) {
            ClientContext clientContext = this;
            synchronized (clientContext) {
                if (this.remoteDirectoryManager == null) {
                    this.remoteDirectoryManager = new DefaultRemoteDirectoryManager(this);
                }
            }
        }
        return this.remoteDirectoryManager;
    }

    public Configuration getSubmarineConfig() {
        return this.submarineConfig;
    }

    public void setSubmarineConfig(Configuration submarineConfig) {
        this.submarineConfig = submarineConfig;
    }

    public RuntimeFactory getRuntimeFactory() {
        return this.runtimeFactory;
    }

    public void setRuntimeFactory(RuntimeFactory runtimeFactory) {
        this.runtimeFactory = runtimeFactory;
    }
}

