/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.common.api.builder;

import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.submarine.common.api.JobComponentStatus;

public class JobComponentStatusBuilder {
    public static JobComponentStatus fromServiceComponent(Component component) {
        long totalAskedContainers = component.getNumberOfContainers();
        int numReadyContainers = 0;
        int numRunningButUnreadyContainers = 0;
        String compName = component.getName();
        for (Container c : component.getContainers()) {
            if (c.getState() == ContainerState.READY) {
                ++numReadyContainers;
                continue;
            }
            if (c.getState() != ContainerState.RUNNING_BUT_UNREADY) continue;
            ++numRunningButUnreadyContainers;
        }
        return new JobComponentStatus(compName, numReadyContainers, numRunningButUnreadyContainers, totalAskedContainers);
    }
}

