/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestQuotaSettingsFactory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaSettingsFactory.class);

    @Test
    public void testAllQuotasAddedToList() {
        QuotaProtos.SpaceQuota spaceQuota = QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(0xC80000000L).setViolationPolicy(QuotaProtos.SpaceViolationPolicy.DISABLE).build();
        long readLimit = 1000L;
        long writeLimit = 500L;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setReadNum(QuotaProtos.TimedQuota.newBuilder().setSoftLimit(1000L).setTimeUnit(HBaseProtos.TimeUnit.MINUTES).build()).setWriteNum(QuotaProtos.TimedQuota.newBuilder().setSoftLimit(500L).setTimeUnit(HBaseProtos.TimeUnit.MINUTES).build()).build();
        QuotaProtos.Quotas quotas = QuotaProtos.Quotas.newBuilder().setSpace(spaceQuota).setThrottle(throttle).build();
        TableName tn = TableName.valueOf((String)"my_table");
        List settings = QuotaSettingsFactory.fromTableQuotas((TableName)tn, (QuotaProtos.Quotas)quotas);
        Assert.assertEquals((long)3L, (long)settings.size());
        boolean seenRead = false;
        boolean seenWrite = false;
        boolean seenSpace = false;
        for (QuotaSettings setting : settings) {
            if (setting instanceof ThrottleSettings) {
                ThrottleSettings throttleSettings = (ThrottleSettings)setting;
                switch (throttleSettings.getThrottleType()) {
                    case READ_NUMBER: {
                        Assert.assertFalse((String)"Should not have multiple read quotas", (boolean)seenRead);
                        Assert.assertEquals((long)1000L, (long)throttleSettings.getSoftLimit());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttleSettings.getTimeUnit()));
                        Assert.assertEquals((Object)tn, (Object)throttleSettings.getTableName());
                        Assert.assertNull((String)"Username should be null", (Object)throttleSettings.getUserName());
                        Assert.assertNull((String)"Namespace should be null", (Object)throttleSettings.getNamespace());
                        seenRead = true;
                        break;
                    }
                    case WRITE_NUMBER: {
                        Assert.assertFalse((String)"Should not have multiple write quotas", (boolean)seenWrite);
                        Assert.assertEquals((long)500L, (long)throttleSettings.getSoftLimit());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttleSettings.getTimeUnit()));
                        Assert.assertEquals((Object)tn, (Object)throttleSettings.getTableName());
                        Assert.assertNull((String)"Username should be null", (Object)throttleSettings.getUserName());
                        Assert.assertNull((String)"Namespace should be null", (Object)throttleSettings.getNamespace());
                        seenWrite = true;
                        break;
                    }
                    default: {
                        Assert.fail((String)("Unexpected throttle type: " + throttleSettings.getThrottleType()));
                        break;
                    }
                }
                continue;
            }
            if (setting instanceof SpaceLimitSettings) {
                Assert.assertFalse((String)"Should not have multiple space quotas", (boolean)seenSpace);
                SpaceLimitSettings spaceLimit = (SpaceLimitSettings)setting;
                Assert.assertEquals((Object)tn, (Object)spaceLimit.getTableName());
                Assert.assertNull((String)"Username should be null", (Object)spaceLimit.getUserName());
                Assert.assertNull((String)"Namespace should be null", (Object)spaceLimit.getNamespace());
                Assert.assertTrue((String)"SpaceLimitSettings should have a SpaceQuota", (boolean)spaceLimit.getProto().hasQuota());
                Assert.assertEquals((Object)spaceQuota, (Object)spaceLimit.getProto().getQuota());
                seenSpace = true;
                continue;
            }
            Assert.fail((String)("Unexpected QuotaSettings implementation: " + setting.getClass()));
        }
        Assert.assertTrue((String)"Should have seen a read quota", (boolean)seenRead);
        Assert.assertTrue((String)"Should have seen a write quota", (boolean)seenWrite);
        Assert.assertTrue((String)"Should have seen a space quota", (boolean)seenSpace);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNeitherTableNorNamespace() {
        QuotaProtos.SpaceQuota spaceQuota = QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(1L).setViolationPolicy(QuotaProtos.SpaceViolationPolicy.DISABLE).build();
        QuotaSettingsFactory.fromSpace(null, null, (QuotaProtos.SpaceQuota)spaceQuota);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBothTableAndNamespace() {
        QuotaProtos.SpaceQuota spaceQuota = QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(1L).setViolationPolicy(QuotaProtos.SpaceViolationPolicy.DISABLE).build();
        QuotaSettingsFactory.fromSpace((TableName)TableName.valueOf((String)"foo"), (String)"bar", (QuotaProtos.SpaceQuota)spaceQuota);
    }

    @Test
    public void testSpaceLimitSettings() {
        TableName tableName = TableName.valueOf((String)"foo");
        long sizeLimit = 80530636800L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tableName, (long)80530636800L, (SpaceViolationPolicy)violationPolicy);
        Assert.assertNotNull((String)"QuotaSettings should not be null", (Object)settings);
        Assert.assertTrue((String)"Should be an instance of SpaceLimitSettings", (boolean)(settings instanceof SpaceLimitSettings));
        SpaceLimitSettings spaceLimitSettings = (SpaceLimitSettings)settings;
        QuotaProtos.SpaceLimitRequest protoRequest = spaceLimitSettings.getProto();
        Assert.assertTrue((String)"Request should have a SpaceQuota", (boolean)protoRequest.hasQuota());
        QuotaProtos.SpaceQuota quota = protoRequest.getQuota();
        Assert.assertEquals((long)80530636800L, (long)quota.getSoftLimit());
        Assert.assertEquals((Object)violationPolicy, (Object)ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)quota.getViolationPolicy()));
        Assert.assertFalse((String)"The remove attribute should be false", (boolean)quota.getRemove());
    }

    @Test
    public void testSpaceLimitSettingsForDeletes() {
        String ns = "ns1";
        TableName tn = TableName.valueOf((String)"tn1");
        QuotaSettings nsSettings = QuotaSettingsFactory.removeNamespaceSpaceLimit((String)"ns1");
        Assert.assertNotNull((String)"QuotaSettings should not be null", (Object)nsSettings);
        Assert.assertTrue((String)"Should be an instance of SpaceLimitSettings", (boolean)(nsSettings instanceof SpaceLimitSettings));
        QuotaProtos.SpaceLimitRequest nsProto = ((SpaceLimitSettings)nsSettings).getProto();
        Assert.assertTrue((String)"Request should have a SpaceQuota", (boolean)nsProto.hasQuota());
        Assert.assertTrue((String)"The remove attribute should be true", (boolean)nsProto.getQuota().getRemove());
        QuotaSettings tableSettings = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        Assert.assertNotNull((String)"QuotaSettings should not be null", (Object)tableSettings);
        Assert.assertTrue((String)"Should be an instance of SpaceLimitSettings", (boolean)(tableSettings instanceof SpaceLimitSettings));
        QuotaProtos.SpaceLimitRequest tableProto = ((SpaceLimitSettings)tableSettings).getProto();
        Assert.assertTrue((String)"Request should have a SpaceQuota", (boolean)tableProto.hasQuota());
        Assert.assertTrue((String)"The remove attribute should be true", (boolean)tableProto.getQuota().getRemove());
    }
}

