/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.DoNothingAsyncRegistry;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class, ClientTests.class})
public class TestBufferedMutator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBufferedMutator.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testAlternateBufferedMutatorImpl() throws IOException {
        BufferedMutator bm;
        BufferedMutatorParams params = new BufferedMutatorParams(TableName.valueOf((String)this.name.getMethodName()));
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.client.registry.impl", DoNothingAsyncRegistry.class.getName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
            bm = connection.getBufferedMutator(params);
            Assert.assertTrue((boolean)(bm instanceof BufferedMutatorImpl));
            params.implementationClassName(MyBufferedMutator.class.getName());
            bm = connection.getBufferedMutator(params);
            Assert.assertTrue((boolean)(bm instanceof MyBufferedMutator));
        }
        conf.set("hbase.client.bufferedmutator.classname", MyBufferedMutator.class.getName());
        connection = ConnectionFactory.createConnection((Configuration)conf);
        var4_4 = null;
        try {
            bm = connection.getBufferedMutator(params);
            Assert.assertTrue((boolean)(bm instanceof MyBufferedMutator));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var4_4 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    public static class MyBufferedMutator
    extends BufferedMutatorImpl {
        MyBufferedMutator(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params) {
            super(conn, rpcCallerFactory, rpcFactory, params);
        }
    }
}

