/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestQuotaGlobalsSettingsBypass {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaGlobalsSettingsBypass.class);

    @Test
    public void testMerge() throws IOException {
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass orig = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, true);
        Assert.assertFalse((boolean)orig.merge((QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, false)).getBypass());
    }

    @Test
    public void testInvalidMerges() throws IOException {
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass userBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass tableBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, TableName.valueOf((String)"table"), null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass namespaceBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, null, "ns", true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass userOnTableBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", TableName.valueOf((String)"table"), null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass userOnNamespaceBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, "ns", true);
        Assert.assertTrue((boolean)userBypass.merge((QuotaSettings)userBypass).getBypass());
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("frank", null, null, false));
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)userOnNamespaceBypass);
        Assert.assertTrue((boolean)tableBypass.merge((QuotaSettings)tableBypass).getBypass());
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, TableName.valueOf((String)"foo"), null, false));
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)userOnNamespaceBypass);
        Assert.assertTrue((boolean)namespaceBypass.merge((QuotaSettings)namespaceBypass).getBypass());
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, null, "sn", false));
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)userOnNamespaceBypass);
        Assert.assertTrue((boolean)userOnTableBypass.merge((QuotaSettings)userOnTableBypass).getBypass());
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("frank", TableName.valueOf((String)"foo"), null, false));
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", TableName.valueOf((String)"bar"), null, false));
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)userOnNamespaceBypass);
        Assert.assertTrue((boolean)userOnNamespaceBypass.merge((QuotaSettings)userOnNamespaceBypass).getBypass());
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("frank", null, "ns", false));
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, "sn", false));
    }

    void expectFailure(QuotaSettings one, QuotaSettings two) throws IOException {
        try {
            one.merge(two);
            Assert.fail((String)("Expected to see an Exception merging " + two + " into " + one));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

