/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;

public class BuilderStyleTest {
    public static void assertClassesAreBuilderStyle(Class ... classes) {
        for (Class clazz : classes) {
            System.out.println("Checking " + clazz);
            Method[] methods = clazz.getDeclaredMethods();
            HashMap<String, HashSet<Method>> methodsBySignature = new HashMap<String, HashSet<Method>>();
            for (Method method : methods) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                Class<?> ret = method.getReturnType();
                if (!method.getName().startsWith("set") && !method.getName().startsWith("add")) continue;
                System.out.println("  " + clazz.getSimpleName() + "." + method.getName() + "() : " + ret.getSimpleName());
                String sig = method.getName();
                for (Class<?> param : method.getParameterTypes()) {
                    sig = sig + param.getName();
                }
                HashSet<Method> sigMethods = (HashSet<Method>)methodsBySignature.get(sig);
                if (sigMethods == null) {
                    sigMethods = new HashSet<Method>();
                    methodsBySignature.put(sig, sigMethods);
                }
                sigMethods.add(method);
            }
            for (Map.Entry entry : methodsBySignature.entrySet()) {
                Method m;
                boolean found = false;
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext() && !(found = clazz.isAssignableFrom((m = (Method)iterator.next()).getReturnType()))) {
                }
                String string = "All setXXX()|addXX() methods in " + clazz.getSimpleName() + " should return a " + clazz.getSimpleName() + " object in builder style. Offending method:" + ((Method)((Set)entry.getValue()).iterator().next()).getName();
                Assert.assertTrue((String)string, (boolean)found);
            }
        }
    }
}

