/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.DoNothingAsyncRegistry;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncAdminRpcPriority {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncAdminRpcPriority.class);
    private static Configuration CONF = HBaseConfiguration.create();
    private MasterProtos.MasterService.Interface masterStub;
    private AdminProtos.AdminService.Interface adminStub;
    private AsyncConnection conn;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws IOException {
        this.masterStub = (MasterProtos.MasterService.Interface)Mockito.mock(MasterProtos.MasterService.Interface.class);
        this.adminStub = (AdminProtos.AdminService.Interface)Mockito.mock(AdminProtos.AdminService.Interface.class);
        ((MasterProtos.MasterService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)MasterProtos.GetProcedureResultResponse.newBuilder().setState(MasterProtos.GetProcedureResultResponse.State.FINISHED).build());
                return null;
            }
        }).when((Object)this.masterStub)).getProcedureResult((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (MasterProtos.GetProcedureResultRequest)ArgumentMatchers.any(MasterProtos.GetProcedureResultRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((MasterProtos.MasterService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)MasterProtos.CreateTableResponse.newBuilder().setProcId(1L).build());
                return null;
            }
        }).when((Object)this.masterStub)).createTable((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (MasterProtos.CreateTableRequest)ArgumentMatchers.any(MasterProtos.CreateTableRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((MasterProtos.MasterService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)MasterProtos.ShutdownResponse.getDefaultInstance());
                return null;
            }
        }).when((Object)this.masterStub)).shutdown((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (MasterProtos.ShutdownRequest)ArgumentMatchers.any(MasterProtos.ShutdownRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((MasterProtos.MasterService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)MasterProtos.StopMasterResponse.getDefaultInstance());
                return null;
            }
        }).when((Object)this.masterStub)).stopMaster((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (MasterProtos.StopMasterRequest)ArgumentMatchers.any(MasterProtos.StopMasterRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((AdminProtos.AdminService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)AdminProtos.StopServerResponse.getDefaultInstance());
                return null;
            }
        }).when((Object)this.adminStub)).stopServer((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (AdminProtos.StopServerRequest)ArgumentMatchers.any(AdminProtos.StopServerRequest.class), (RpcCallback)ArgumentMatchers.any());
        this.conn = new AsyncConnectionImpl(CONF, new DoNothingAsyncRegistry(CONF), "test", UserProvider.instantiate((Configuration)CONF).getCurrent()){

            CompletableFuture<MasterProtos.MasterService.Interface> getMasterStub() {
                return CompletableFuture.completedFuture(TestAsyncAdminRpcPriority.this.masterStub);
            }

            AdminProtos.AdminService.Interface getAdminStub(ServerName serverName) throws IOException {
                return TestAsyncAdminRpcPriority.this.adminStub;
            }
        };
    }

    private HBaseRpcController assertPriority(final int priority) {
        return (HBaseRpcController)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<HBaseRpcController>(){

            public boolean matches(HBaseRpcController controller) {
                return controller.getPriority() == priority;
            }
        });
    }

    @Test
    public void testCreateNormalTable() {
        this.conn.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).build()).join();
        ((MasterProtos.MasterService.Interface)Mockito.verify((Object)this.masterStub, (VerificationMode)Mockito.times((int)1))).createTable((RpcController)this.assertPriority(0), (MasterProtos.CreateTableRequest)ArgumentMatchers.any(MasterProtos.CreateTableRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCreateSystemTable() {
        this.conn.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).build()).join();
        ((MasterProtos.MasterService.Interface)Mockito.verify((Object)this.masterStub, (VerificationMode)Mockito.times((int)1))).createTable((RpcController)this.assertPriority(200), (MasterProtos.CreateTableRequest)ArgumentMatchers.any(MasterProtos.CreateTableRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCreateMetaTable() {
        this.conn.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).build()).join();
        ((MasterProtos.MasterService.Interface)Mockito.verify((Object)this.masterStub, (VerificationMode)Mockito.times((int)1))).createTable((RpcController)this.assertPriority(200), (MasterProtos.CreateTableRequest)ArgumentMatchers.any(MasterProtos.CreateTableRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testShutdown() {
        this.conn.getAdmin().shutdown().join();
        ((MasterProtos.MasterService.Interface)Mockito.verify((Object)this.masterStub, (VerificationMode)Mockito.times((int)1))).shutdown((RpcController)this.assertPriority(200), (MasterProtos.ShutdownRequest)ArgumentMatchers.any(MasterProtos.ShutdownRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testStopMaster() {
        this.conn.getAdmin().stopMaster().join();
        ((MasterProtos.MasterService.Interface)Mockito.verify((Object)this.masterStub, (VerificationMode)Mockito.times((int)1))).stopMaster((RpcController)this.assertPriority(200), (MasterProtos.StopMasterRequest)ArgumentMatchers.any(MasterProtos.StopMasterRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testStopRegionServer() {
        this.conn.getAdmin().stopRegionServer(ServerName.valueOf((String)"rs", (int)16010, (long)12345L)).join();
        ((AdminProtos.AdminService.Interface)Mockito.verify((Object)this.adminStub, (VerificationMode)Mockito.times((int)1))).stopServer((RpcController)this.assertPriority(200), (AdminProtos.StopServerRequest)ArgumentMatchers.any(AdminProtos.StopServerRequest.class), (RpcCallback)ArgumentMatchers.any());
    }
}

