/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.client.AsyncMetaRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.DoNothingAsyncRegistry;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestAsyncMetaRegionLocatorFailFast {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncMetaRegionLocatorFailFast.class);
    private static Configuration CONF = HBaseConfiguration.create();
    private static AsyncMetaRegionLocator LOCATOR;

    @BeforeClass
    public static void setUp() {
        LOCATOR = new AsyncMetaRegionLocator((AsyncRegistry)new FaultyAsyncRegistry(CONF));
    }

    @Test(expected=DoNotRetryIOException.class)
    public void test() throws IOException {
        FutureUtils.get((Future)LOCATOR.getRegionLocations(0, false));
    }

    private static final class FaultyAsyncRegistry
    extends DoNothingAsyncRegistry {
        public FaultyAsyncRegistry(Configuration conf) {
            super(conf);
        }

        @Override
        public CompletableFuture<RegionLocations> getMetaRegionLocation() {
            return FutureUtils.failedFuture((Throwable)new DoNotRetryRegionException("inject error"));
        }
    }
}

