/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BuilderStyleTest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PrettyPrinter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestColumnFamilyDescriptorBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestColumnFamilyDescriptorBuilder.class);
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testBuilder() throws DeserializationException {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])HConstants.CATALOG_FAMILY).setInMemory(true).setScope(0).setBloomFilterType(BloomType.NONE);
        int v = 123;
        builder.setBlocksize(123);
        builder.setTimeToLive(123);
        builder.setBlockCacheEnabled(false);
        builder.setValue(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
        builder.setMaxVersions(123);
        Assert.assertEquals((long)123L, (long)builder.build().getMaxVersions());
        builder.setMinVersions(123);
        Assert.assertEquals((long)123L, (long)builder.build().getMinVersions());
        builder.setKeepDeletedCells(KeepDeletedCells.TRUE);
        builder.setInMemory(true);
        boolean inmemory = builder.build().isInMemory();
        builder.setScope(123);
        builder.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
        builder.setBloomFilterType(BloomType.ROW);
        builder.setCompressionType(Compression.Algorithm.SNAPPY);
        builder.setMobEnabled(true);
        builder.setMobThreshold(1000L);
        builder.setDFSReplication((short)123);
        ColumnFamilyDescriptor hcd = builder.build();
        byte[] bytes = ColumnFamilyDescriptorBuilder.toByteArray((ColumnFamilyDescriptor)hcd);
        ColumnFamilyDescriptor deserializedHcd = ColumnFamilyDescriptorBuilder.parseFrom((byte[])bytes);
        Assert.assertTrue((boolean)hcd.equals(deserializedHcd));
        Assert.assertEquals((long)123L, (long)hcd.getBlocksize());
        Assert.assertEquals((long)123L, (long)hcd.getTimeToLive());
        Assert.assertTrue((boolean)Bytes.equals((byte[])hcd.getValue(Bytes.toBytes((String)"a")), (byte[])deserializedHcd.getValue(Bytes.toBytes((String)"a"))));
        Assert.assertEquals((long)hcd.getMaxVersions(), (long)deserializedHcd.getMaxVersions());
        Assert.assertEquals((long)hcd.getMinVersions(), (long)deserializedHcd.getMinVersions());
        Assert.assertEquals((Object)hcd.getKeepDeletedCells(), (Object)deserializedHcd.getKeepDeletedCells());
        Assert.assertEquals((Object)inmemory, (Object)deserializedHcd.isInMemory());
        Assert.assertEquals((long)hcd.getScope(), (long)deserializedHcd.getScope());
        Assert.assertTrue((boolean)deserializedHcd.getCompressionType().equals((Object)Compression.Algorithm.SNAPPY));
        Assert.assertTrue((boolean)deserializedHcd.getDataBlockEncoding().equals((Object)DataBlockEncoding.FAST_DIFF));
        Assert.assertTrue((boolean)deserializedHcd.getBloomFilterType().equals((Object)BloomType.ROW));
        Assert.assertEquals((Object)hcd.isMobEnabled(), (Object)deserializedHcd.isMobEnabled());
        Assert.assertEquals((long)hcd.getMobThreshold(), (long)deserializedHcd.getMobThreshold());
        Assert.assertEquals((long)123L, (long)deserializedHcd.getDFSReplication());
    }

    @Test
    public void testHColumnDescriptorShouldThrowIAEWhenFamilyNameEmpty() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Column Family name can not be empty");
        ColumnFamilyDescriptorBuilder.of((String)"");
    }

    @Test
    public void testAddGetRemoveConfiguration() {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"foo"));
        String key = "Some";
        String value = "value";
        builder.setConfiguration(key, value);
        Assert.assertEquals((Object)value, (Object)builder.build().getConfigurationValue(key));
        builder.removeConfiguration(key);
        Assert.assertEquals(null, (Object)builder.build().getConfigurationValue(key));
    }

    @Test
    public void testMobValuesInHColumnDescriptorShouldReadable() {
        boolean isMob = true;
        long threshold = 1000L;
        String policy = "weekly";
        String isMobString = PrettyPrinter.format((String)String.valueOf(isMob), (PrettyPrinter.Unit)HColumnDescriptor.getUnit((String)"IS_MOB"));
        String thresholdString = PrettyPrinter.format((String)String.valueOf(threshold), (PrettyPrinter.Unit)HColumnDescriptor.getUnit((String)"MOB_THRESHOLD"));
        String policyString = PrettyPrinter.format((String)Bytes.toStringBinary((byte[])Bytes.toBytes((String)policy)), (PrettyPrinter.Unit)HColumnDescriptor.getUnit((String)"MOB_COMPACT_PARTITION_POLICY"));
        Assert.assertEquals((Object)String.valueOf(isMob), (Object)isMobString);
        Assert.assertEquals((Object)String.valueOf(threshold), (Object)thresholdString);
        Assert.assertEquals((Object)String.valueOf(policy), (Object)policyString);
    }

    @Test
    public void testClassMethodsAreBuilderStyle() {
        BuilderStyleTest.assertClassesAreBuilderStyle(ColumnFamilyDescriptorBuilder.class);
    }

    @Test
    public void testSetTimeToLive() throws HBaseException {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"foo"));
        String ttl = "50000";
        builder.setTimeToLive(ttl);
        Assert.assertEquals((long)50000L, (long)builder.build().getTimeToLive());
        ttl = "50000 seconds";
        builder.setTimeToLive(ttl);
        Assert.assertEquals((long)50000L, (long)builder.build().getTimeToLive());
        ttl = "";
        builder.setTimeToLive(ttl);
        Assert.assertEquals((long)0L, (long)builder.build().getTimeToLive());
        ttl = "FOREVER";
        builder.setTimeToLive(ttl);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)builder.build().getTimeToLive());
        ttl = "1 HOUR 10 minutes 1 second";
        builder.setTimeToLive(ttl);
        Assert.assertEquals((long)4201L, (long)builder.build().getTimeToLive());
        ttl = "500 Days 23 HOURS";
        builder.setTimeToLive(ttl);
        Assert.assertEquals((long)43282800L, (long)builder.build().getTimeToLive());
        ttl = "43282800 SECONDS (500 Days 23 hours)";
        builder.setTimeToLive(ttl);
        Assert.assertEquals((long)43282800L, (long)builder.build().getTimeToLive());
    }
}

