/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestIPCUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIPCUtil.class);

    private static Throwable create(Class<? extends Throwable> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Constructor<? extends Throwable> c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException c) {
            try {
                Constructor<? extends Throwable> c2 = clazz.getDeclaredConstructor(String.class);
                c2.setAccessible(true);
                return c2.newInstance("error");
            }
            catch (NoSuchMethodException c2) {
                try {
                    Constructor<? extends Throwable> c3 = clazz.getDeclaredConstructor(Throwable.class);
                    c3.setAccessible(true);
                    return c3.newInstance(new Exception("error"));
                }
                catch (NoSuchMethodException c3) {
                    try {
                        Constructor<? extends Throwable> c4 = clazz.getDeclaredConstructor(String.class, Throwable.class);
                        c4.setAccessible(true);
                        return c4.newInstance("error", new Exception("error"));
                    }
                    catch (NoSuchMethodException c4) {
                        Constructor<? extends Throwable> c5 = clazz.getDeclaredConstructor(Throwable.class, Throwable.class);
                        c5.setAccessible(true);
                        return c5.newInstance(new Exception("error"), "error");
                    }
                }
            }
        }
    }

    @Test
    public void testWrapConnectionException() throws Exception {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Class clazz : ClientExceptionsUtil.getConnectionExceptionTypes()) {
            exceptions.add(TestIPCUtil.create(clazz));
        }
        InetSocketAddress addr = InetSocketAddress.createUnresolved("127.0.0.1", 12345);
        for (Throwable exception : exceptions) {
            if (exception instanceof TimeoutException) {
                Assert.assertThat((Object)IPCUtil.wrapException((InetSocketAddress)addr, (Throwable)exception), (Matcher)CoreMatchers.instanceOf(TimeoutIOException.class));
                continue;
            }
            Assert.assertThat((Object)IPCUtil.wrapException((InetSocketAddress)addr, (Throwable)exception), (Matcher)CoreMatchers.instanceOf(exception.getClass()));
        }
    }
}

