/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.protobuf.RpcCallback;
import ch.cern.hbase.thirdparty.com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.DoNothingAsyncRegistry;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncTableRpcPriority {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableRpcPriority.class);
    private static Configuration CONF = HBaseConfiguration.create();
    private ClientProtos.ClientService.Interface stub;
    private AsyncConnection conn;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws IOException {
        this.stub = (ClientProtos.ClientService.Interface)Mockito.mock(ClientProtos.ClientService.Interface.class);
        final AtomicInteger scanNextCalled = new AtomicInteger(0);
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.ScanRequest req = (ClientProtos.ScanRequest)invocation.getArgument(1);
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                if (!req.hasScannerId()) {
                    done.run((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(1L).setTtl(800).setMoreResultsInRegion(true).setMoreResults(true).build());
                } else if (req.hasCloseScanner() && req.getCloseScanner()) {
                    done.run((Object)ClientProtos.ScanResponse.getDefaultInstance());
                } else {
                    Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(Bytes.toBytes((int)scanNextCalled.incrementAndGet())).setFamily(Bytes.toBytes((String)"cf")).setQualifier(Bytes.toBytes((String)"cq")).setValue(Bytes.toBytes((String)"v")).build();
                    Result result = Result.create(Arrays.asList(cell));
                    done.run((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(1L).setTtl(800).setMoreResultsInRegion(true).setMoreResults(true).addResults(ProtobufUtil.toResult((Result)result)).build());
                }
                return null;
            }
        }).when((Object)this.stub)).scan((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.MultiResponse resp = ClientProtos.MultiResponse.newBuilder().addRegionActionResult(ClientProtos.RegionActionResult.newBuilder().addResultOrException(ClientProtos.ResultOrException.newBuilder().setResult(ProtobufUtil.toResult((Result)new Result())))).build();
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)resp);
                return null;
            }
        }).when((Object)this.stub)).multi((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.MutateResponse resp;
                ClientProtos.MutationProto req = ((ClientProtos.MutateRequest)invocation.getArgument(1)).getMutation();
                switch (req.getMutateType()) {
                    case INCREMENT: {
                        ClientProtos.MutationProto.ColumnValue value = req.getColumnValue(0);
                        ClientProtos.MutationProto.ColumnValue.QualifierValue qvalue = value.getQualifierValue(0);
                        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(req.getRow().toByteArray()).setFamily(value.getFamily().toByteArray()).setQualifier(qvalue.getQualifier().toByteArray()).setValue(qvalue.getValue().toByteArray()).build();
                        resp = ClientProtos.MutateResponse.newBuilder().setResult(ProtobufUtil.toResult((Result)Result.create(Arrays.asList(cell)))).build();
                        break;
                    }
                    default: {
                        resp = ClientProtos.MutateResponse.getDefaultInstance();
                    }
                }
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)resp);
                return null;
            }
        }).when((Object)this.stub)).mutate((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                done.run((Object)ClientProtos.GetResponse.getDefaultInstance());
                return null;
            }
        }).when((Object)this.stub)).get((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.GetRequest)ArgumentMatchers.any(ClientProtos.GetRequest.class), (RpcCallback)ArgumentMatchers.any());
        this.conn = new AsyncConnectionImpl(CONF, new DoNothingAsyncRegistry(CONF), "test", UserProvider.instantiate((Configuration)CONF).getCurrent()){

            AsyncRegionLocator getLocator() {
                AsyncRegionLocator locator = (AsyncRegionLocator)Mockito.mock(AsyncRegionLocator.class);
                Answer<CompletableFuture<HRegionLocation>> answer = new Answer<CompletableFuture<HRegionLocation>>(){

                    public CompletableFuture<HRegionLocation> answer(InvocationOnMock invocation) throws Throwable {
                        TableName tableName = (TableName)invocation.getArgument(0);
                        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
                        ServerName serverName = ServerName.valueOf((String)"rs", (int)16010, (long)12345L);
                        HRegionLocation loc = new HRegionLocation(info, serverName);
                        return CompletableFuture.completedFuture(loc);
                    }
                };
                ((AsyncRegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((TableName)ArgumentMatchers.any(TableName.class), (byte[])ArgumentMatchers.any(byte[].class), (RegionLocateType)ArgumentMatchers.any(RegionLocateType.class), ArgumentMatchers.anyLong());
                ((AsyncRegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((TableName)ArgumentMatchers.any(TableName.class), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), (RegionLocateType)ArgumentMatchers.any(RegionLocateType.class), ArgumentMatchers.anyLong());
                return locator;
            }

            ClientProtos.ClientService.Interface getRegionServerStub(ServerName serverName) throws IOException {
                return TestAsyncTableRpcPriority.this.stub;
            }
        };
    }

    private HBaseRpcController assertPriority(final int priority) {
        return (HBaseRpcController)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<HBaseRpcController>(){

            public boolean matches(HBaseRpcController controller) {
                return controller.getPriority() == priority;
            }
        });
    }

    @Test
    public void testGet() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).get(new Get(Bytes.toBytes((int)0)).setPriority(11)).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).get((RpcController)this.assertPriority(11), (ClientProtos.GetRequest)ArgumentMatchers.any(ClientProtos.GetRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testGetNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).get(new Get(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).get((RpcController)this.assertPriority(0), (ClientProtos.GetRequest)ArgumentMatchers.any(ClientProtos.GetRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testGetSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).get(new Get(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).get((RpcController)this.assertPriority(200), (ClientProtos.GetRequest)ArgumentMatchers.any(ClientProtos.GetRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testGetMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).get(new Get(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).get((RpcController)this.assertPriority(200), (ClientProtos.GetRequest)ArgumentMatchers.any(ClientProtos.GetRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testPut() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).put(new Put(Bytes.toBytes((int)0)).setPriority(12).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(12), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testPutNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).put(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(0), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testPutSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).put(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testPutMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).put(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testDelete() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).delete(new Delete(Bytes.toBytes((int)0)).setPriority(13)).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(13), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testDeleteNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).delete(new Delete(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(0), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testDeleteSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).delete(new Delete(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testDeleteMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).delete(new Delete(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testAppend() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).append(new Append(Bytes.toBytes((int)0)).setPriority(14).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(14), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testAppendNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).append(new Append(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(0), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testAppendSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).append(new Append(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testAppendMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).append(new Append(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testIncrement() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).increment(new Increment(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L).setPriority(15)).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(15), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testIncrementNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).incrementColumnValue(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(0), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testIncrementSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).incrementColumnValue(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testIncrementMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).incrementColumnValue(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndPut() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifNotExists().thenPut(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")).setPriority(16)).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(16), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndPutNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifNotExists().thenPut(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(0), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndPutSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifNotExists().thenPut(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndPutMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifNotExists().thenPut(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndDelete() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v")).thenDelete(new Delete(Bytes.toBytes((int)0)).setPriority(17)).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(17), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndDeleteNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v")).thenDelete(new Delete(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(0), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndDeleteSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v")).thenDelete(new Delete(Bytes.toBytes((int)0))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndDeleteMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifNotExists().thenPut(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).mutate((RpcController)this.assertPriority(200), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndMutate() throws IOException {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v")).thenMutate(new RowMutations(Bytes.toBytes((int)0)).add((Mutation)new Delete(Bytes.toBytes((int)0)).setPriority(18))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).multi((RpcController)this.assertPriority(18), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndMutateNormalTable() throws IOException {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v")).thenMutate(new RowMutations(Bytes.toBytes((int)0)).add((Mutation)new Delete(Bytes.toBytes((int)0)))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).multi((RpcController)this.assertPriority(0), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndMutateSystemTable() throws IOException {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v")).thenMutate(new RowMutations(Bytes.toBytes((int)0)).add((Mutation)new Delete(Bytes.toBytes((int)0)))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).multi((RpcController)this.assertPriority(200), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testCheckAndMutateMetaTable() throws IOException {
        this.conn.getTable(TableName.META_TABLE_NAME).checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v")).thenMutate(new RowMutations(Bytes.toBytes((int)0)).add((Mutation)new Delete(Bytes.toBytes((int)0)))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).multi((RpcController)this.assertPriority(200), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testScan() throws IOException, InterruptedException {
        try (ResultScanner scanner = this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).getScanner(new Scan().setCaching(1).setMaxResultSize(1L).setPriority(19));){
            Assert.assertNotNull((Object)scanner.next());
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.atLeast((int)4))).scan((RpcController)this.assertPriority(19), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testScanNormalTable() throws IOException, InterruptedException {
        try (ResultScanner scanner = this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).getScanner(new Scan().setCaching(1).setMaxResultSize(1L));){
            Assert.assertNotNull((Object)scanner.next());
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.atLeast((int)4))).scan((RpcController)this.assertPriority(0), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testScanSystemTable() throws IOException, InterruptedException {
        try (ResultScanner scanner = this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).getScanner(new Scan().setCaching(1).setMaxResultSize(1L));){
            Assert.assertNotNull((Object)scanner.next());
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.atLeast((int)4))).scan((RpcController)this.assertPriority(200), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testScanMetaTable() throws IOException, InterruptedException {
        try (ResultScanner scanner = this.conn.getTable(TableName.META_TABLE_NAME).getScanner(new Scan().setCaching(1).setMaxResultSize(1L));){
            Assert.assertNotNull((Object)scanner.next());
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.atLeast((int)4))).scan((RpcController)this.assertPriority(200), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testBatchNormalTable() {
        this.conn.getTable(TableName.valueOf((String)this.name.getMethodName())).batchAll(Arrays.asList(new Delete(Bytes.toBytes((int)0)))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).multi((RpcController)this.assertPriority(0), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testBatchSystemTable() {
        this.conn.getTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName())).batchAll(Arrays.asList(new Delete(Bytes.toBytes((int)0)))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).multi((RpcController)this.assertPriority(200), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
    }

    @Test
    public void testBatchMetaTable() {
        this.conn.getTable(TableName.META_TABLE_NAME).batchAll(Arrays.asList(new Delete(Bytes.toBytes((int)0)))).join();
        ((ClientProtos.ClientService.Interface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).multi((RpcController)this.assertPriority(200), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
    }
}

