/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={ClientTests.class, SmallTests.class})
public class TestReversedScannerCallable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReversedScannerCallable.class);
    @Mock
    private ClusterConnection connection;
    @Mock
    private Scan scan;
    @Mock
    private RpcControllerFactory rpcFactory;
    @Mock
    private RegionLocations regionLocations;
    private final byte[] ROW = Bytes.toBytes((String)"row1");

    @Before
    public void setUp() throws Exception {
        HRegionLocation regionLocation = (HRegionLocation)Mockito.mock(HRegionLocation.class);
        ServerName serverName = (ServerName)Mockito.mock(ServerName.class);
        Mockito.when((Object)this.connection.getConfiguration()).thenReturn((Object)new Configuration());
        Mockito.when((Object)this.regionLocations.size()).thenReturn((Object)1);
        Mockito.when((Object)this.regionLocations.getRegionLocation(0)).thenReturn((Object)regionLocation);
        Mockito.when((Object)regionLocation.getHostname()).thenReturn((Object)"localhost");
        Mockito.when((Object)regionLocation.getServerName()).thenReturn((Object)serverName);
        Mockito.when((Object)this.scan.includeStartRow()).thenReturn((Object)true);
        Mockito.when((Object)this.scan.getStartRow()).thenReturn((Object)this.ROW);
    }

    @Test
    public void testPrepareDoesNotUseCache() throws Exception {
        TableName tableName = TableName.valueOf((String)"MyTable");
        Mockito.when((Object)this.connection.relocateRegion(tableName, this.ROW, 0)).thenReturn((Object)this.regionLocations);
        ReversedScannerCallable callable = new ReversedScannerCallable(this.connection, tableName, this.scan, null, this.rpcFactory);
        callable.prepare(true);
        ((ClusterConnection)Mockito.verify((Object)this.connection)).relocateRegion(tableName, this.ROW, 0);
    }

    @Test
    public void testPrepareUsesCache() throws Exception {
        TableName tableName = TableName.valueOf((String)"MyTable");
        Mockito.when((Object)this.connection.locateRegion(tableName, this.ROW, true, true, 0)).thenReturn((Object)this.regionLocations);
        ReversedScannerCallable callable = new ReversedScannerCallable(this.connection, tableName, this.scan, null, this.rpcFactory);
        callable.prepare(false);
        ((ClusterConnection)Mockito.verify((Object)this.connection)).locateRegion(tableName, this.ROW, true, true, 0);
    }
}

