/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestRowComparator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowComparator.class);
    private static final List<byte[]> DEFAULT_ROWS = IntStream.range(1, 9).mapToObj(String::valueOf).map(Bytes::toBytes).collect(Collectors.toList());

    @Test
    public void testPut() {
        TestRowComparator.test(row -> new Put(row));
    }

    @Test
    public void testDelete() {
        TestRowComparator.test(row -> new Delete(row));
    }

    @Test
    public void testAppend() {
        TestRowComparator.test(row -> new Append(row));
    }

    @Test
    public void testIncrement() {
        TestRowComparator.test(row -> new Increment(row));
    }

    @Test
    public void testGet() {
        TestRowComparator.test(row -> new Get(row));
    }

    private static <T extends Row> void test(Function<byte[], T> f) {
        ArrayList rows = new ArrayList(DEFAULT_ROWS.stream().map(f).collect(Collectors.toList()));
        do {
            Collections.shuffle(rows);
        } while (TestRowComparator.needShuffle(rows));
        Collections.sort(rows, Row.COMPARATOR);
        TestRowComparator.assertSort(rows);
    }

    private static boolean needShuffle(List<? extends Row> rows) {
        Assert.assertFalse((boolean)rows.isEmpty());
        Assert.assertEquals((long)DEFAULT_ROWS.size(), (long)rows.size());
        for (int i = 0; i != DEFAULT_ROWS.size(); ++i) {
            if (Bytes.equals((byte[])DEFAULT_ROWS.get(i), (byte[])rows.get(i).getRow())) continue;
            return false;
        }
        return true;
    }

    private static void assertSort(List<? extends Row> rows) {
        Assert.assertFalse((boolean)rows.isEmpty());
        Assert.assertEquals((long)DEFAULT_ROWS.size(), (long)rows.size());
        for (int i = 0; i != DEFAULT_ROWS.size(); ++i) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])DEFAULT_ROWS.get(i), (byte[])rows.get(i).getRow()));
        }
    }
}

