/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class, ClientTests.class})
public class TestSnapshotFromAdmin {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotFromAdmin.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotFromAdmin.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testBackoffLogic() throws Exception {
        int pauseTime = 100;
        int maxWaitTime = HConstants.RETRY_BACKOFF[HConstants.RETRY_BACKOFF.length - 1] * 100;
        int numRetries = HConstants.RETRY_BACKOFF.length;
        long ignoreExpectedTime = 0L;
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            ignoreExpectedTime += (long)(HConstants.RETRY_BACKOFF[i] * 100);
        }
        long time = 300L + (long)(maxWaitTime / numRetries * 3) + 300L;
        Assert.assertTrue((String)"Capped snapshot wait time isn't less that the uncapped backoff time - further testing won't prove anything.", (time < ignoreExpectedTime ? 1 : 0) != 0);
        ConnectionImplementation mockConnection = (ConnectionImplementation)Mockito.mock(ConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.client.retries.number", numRetries);
        conf.setLong("hbase.client.pause", 100L);
        MasterKeepAliveConnection mockMaster = (MasterKeepAliveConnection)Mockito.mock(MasterKeepAliveConnection.class);
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockConnection.getMaster()).thenReturn((Object)mockMaster);
        RpcRetryingCallerFactory callerFactory = new RpcRetryingCallerFactory(conf);
        RpcControllerFactory controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        Mockito.when((Object)controllerFactory.newController()).thenReturn(Mockito.mock(HBaseRpcController.class));
        Mockito.when((Object)mockConnection.getRpcRetryingCallerFactory()).thenReturn((Object)callerFactory);
        Mockito.when((Object)mockConnection.getRpcControllerFactory()).thenReturn((Object)controllerFactory);
        MasterProtos.SnapshotResponse response = MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout((long)maxWaitTime).build();
        Mockito.when((Object)mockMaster.snapshot((RpcController)Mockito.any(), (MasterProtos.SnapshotRequest)Mockito.any())).thenReturn((Object)response);
        MasterProtos.IsSnapshotDoneResponse.Builder builder = MasterProtos.IsSnapshotDoneResponse.newBuilder();
        builder.setDone(false);
        Mockito.when((Object)mockMaster.isSnapshotDone((RpcController)Mockito.any(), (MasterProtos.IsSnapshotDoneRequest)Mockito.any())).thenReturn((Object)builder.build(), (Object[])new MasterProtos.IsSnapshotDoneResponse[]{builder.build(), builder.build(), builder.build(), builder.build(), builder.setDone(true).build()});
        HBaseAdmin admin = new HBaseAdmin((ClusterConnection)mockConnection);
        String snapshot = "snapshot";
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        long start = System.currentTimeMillis();
        admin.snapshot(snapshot, table);
        long finish = System.currentTimeMillis();
        long elapsed = finish - start;
        Assert.assertTrue((String)("Elapsed time:" + elapsed + " is more than expected max:" + time), (elapsed <= time ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testValidateSnapshotName() throws Exception {
        ConnectionImplementation mockConnection = (ConnectionImplementation)Mockito.mock(ConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        RpcRetryingCallerFactory callerFactory = new RpcRetryingCallerFactory(conf);
        RpcControllerFactory controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        Mockito.when((Object)controllerFactory.newController()).thenReturn(Mockito.mock(HBaseRpcController.class));
        Mockito.when((Object)mockConnection.getRpcRetryingCallerFactory()).thenReturn((Object)callerFactory);
        Mockito.when((Object)mockConnection.getRpcControllerFactory()).thenReturn((Object)controllerFactory);
        HBaseAdmin admin = new HBaseAdmin((ClusterConnection)mockConnection);
        this.failSnapshotStart((Admin)admin, new SnapshotDescription(".hbase-snapshot"));
        this.failSnapshotStart((Admin)admin, new SnapshotDescription("-snapshot"));
        this.failSnapshotStart((Admin)admin, new SnapshotDescription("snapshot fails"));
        this.failSnapshotStart((Admin)admin, new SnapshotDescription("snap$hot"));
        this.failSnapshotStart((Admin)admin, new SnapshotDescription("snap:hot"));
        this.failSnapshotDescriptorCreation("snapshot", ".table");
        this.failSnapshotDescriptorCreation("snapshot", "-table");
        this.failSnapshotDescriptorCreation("snapshot", "table fails");
        this.failSnapshotDescriptorCreation("snapshot", "tab%le");
        MasterKeepAliveConnection master = (MasterKeepAliveConnection)Mockito.mock(MasterKeepAliveConnection.class);
        Mockito.when((Object)mockConnection.getMaster()).thenReturn((Object)master);
        MasterProtos.SnapshotResponse response = MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(0L).build();
        Mockito.when((Object)master.snapshot((RpcController)Mockito.any(), (MasterProtos.SnapshotRequest)Mockito.any())).thenReturn((Object)response);
        MasterProtos.IsSnapshotDoneResponse doneResponse = MasterProtos.IsSnapshotDoneResponse.newBuilder().setDone(true).build();
        Mockito.when((Object)master.isSnapshotDone((RpcController)Mockito.any(), (MasterProtos.IsSnapshotDoneRequest)Mockito.any())).thenReturn((Object)doneResponse);
        admin.snapshot(new SnapshotDescription("snapshot", TableName.valueOf((String)this.name.getMethodName())));
    }

    private void failSnapshotStart(Admin admin, SnapshotDescription snapshot) throws IOException {
        try {
            admin.snapshot(snapshot);
            Assert.fail((String)("Snapshot should not have succeed with name:" + snapshot.getName()));
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Correctly failed to start snapshot:" + e.getMessage());
        }
    }

    private void failSnapshotDescriptorCreation(String snapshotName, String tableName) {
        try {
            new SnapshotDescription(snapshotName, tableName);
            Assert.fail((String)("SnapshotDescription should not have succeed with name:" + snapshotName));
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Correctly failed to create SnapshotDescription:" + e.getMessage());
        }
    }
}

