/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BuilderStyleTest;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestTableDescriptorBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableDescriptorBuilder.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTableDescriptorBuilder.class);
    @Rule
    public TestName name = new TestName();
    String[] legalTableNames = new String[]{"foo", "with-dash_under.dot", "_under_start_ok", "with-dash.with_underscore", "02-01-2012.my_table_01-02", "xyz._mytable_", "9_9_0.table_02", "dot1.dot2.table", "new.-mytable", "with-dash.with.dot", "legal..t2", "legal..legal.t2", "trailingdots..", "trailing.dots...", "ns:mytable", "ns:_mytable_", "ns:my_table_01-02"};
    String[] illegalTableNames = new String[]{".dot_start_illegal", "-dash_start_illegal", "spaces not ok", "-dash-.start_illegal", "new.table with space", "01 .table", "ns:-illegaldash", "new:.illegaldot", "new:illegalcolon1:", "new:illegalcolon1:2"};

    @Test(expected=IOException.class)
    public void testAddCoprocessorTwice() throws IOException {
        String cpName = "a.b.c.d";
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setCoprocessor(cpName).setCoprocessor(cpName).build();
    }

    @Test
    public void testPb() throws DeserializationException, IOException {
        int v = 123;
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setMaxFileSize(123L).setDurability(Durability.ASYNC_WAL).setReadOnly(true).setRegionReplication(2).build();
        byte[] bytes = TableDescriptorBuilder.toByteArray((TableDescriptor)htd);
        TableDescriptor deserializedHtd = TableDescriptorBuilder.parseFrom((byte[])bytes);
        Assert.assertEquals((Object)htd, (Object)deserializedHtd);
        Assert.assertEquals((long)123L, (long)deserializedHtd.getMaxFileSize());
        Assert.assertTrue((boolean)deserializedHtd.isReadOnly());
        Assert.assertEquals((Object)Durability.ASYNC_WAL, (Object)deserializedHtd.getDurability());
        Assert.assertEquals((long)2L, (long)deserializedHtd.getRegionReplication());
    }

    @Test
    public void testGetSetRemoveCP() throws Exception {
        String className = "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver";
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setCoprocessor(className).build();
        Assert.assertTrue((boolean)desc.hasCoprocessor(className));
        desc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).removeCoprocessor(className).build();
        Assert.assertFalse((boolean)desc.hasCoprocessor(className));
    }

    @Test
    public void testSetListRemoveCP() throws Exception {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        Assert.assertTrue((boolean)desc.getCoprocessorDescriptors().isEmpty());
        String className1 = "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver";
        String className2 = "org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver";
        desc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).setCoprocessor(className1).build();
        Assert.assertTrue((desc.getCoprocessorDescriptors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)desc.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).anyMatch(name -> name.equals(className1)));
        desc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).setCoprocessor(className2).build();
        Assert.assertTrue((desc.getCoprocessorDescriptors().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)desc.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).anyMatch(name -> name.equals(className2)));
        desc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).removeCoprocessor(className1).build();
        Assert.assertTrue((desc.getCoprocessorDescriptors().size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)desc.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).anyMatch(name -> name.equals(className1)));
        Assert.assertTrue((boolean)desc.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).anyMatch(name -> name.equals(className2)));
        desc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).removeCoprocessor(className2).build();
        Assert.assertTrue((boolean)desc.getCoprocessorDescriptors().isEmpty());
        Assert.assertFalse((boolean)desc.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).anyMatch(name -> name.equals(className1)));
        Assert.assertFalse((boolean)desc.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).anyMatch(name -> name.equals(className2)));
    }

    @Test
    public void testRemoveString() {
        byte[] key = Bytes.toBytes((String)"Some");
        byte[] value = Bytes.toBytes((String)"value");
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setValue(key, value).build();
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])desc.getValue(key)));
        desc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).removeValue(key).build();
        Assert.assertTrue((desc.getValue(key) == null ? 1 : 0) != 0);
    }

    @Test
    public void testLegalTableNames() {
        for (String tn : this.legalTableNames) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
        }
    }

    @Test
    public void testIllegalTableNames() {
        for (String tn : this.illegalTableNames) {
            try {
                TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
                Assert.fail((String)("invalid tablename " + tn + " should have failed"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLegalTableNamesRegex() {
        for (String tn : this.legalTableNames) {
            TableName tName = TableName.valueOf((String)tn);
            Assert.assertTrue((String)("Testing: '" + tn + "'"), (boolean)Pattern.matches("(?:(?:(?:(?:[_\\p{Digit}\\p{IsAlphabetic}]+)\\:)?)(?:(?:[_\\p{Digit}\\p{IsAlphabetic}][-_.\\p{Digit}\\p{IsAlphabetic}]*)))", tName.getNameAsString()));
        }
    }

    @Test
    public void testIllegalTableNamesRegex() {
        for (String tn : this.illegalTableNames) {
            LOG.info("Testing: '" + tn + "'");
            Assert.assertFalse((boolean)Pattern.matches("(?:(?:(?:(?:[_\\p{Digit}\\p{IsAlphabetic}]+)\\:)?)(?:(?:[_\\p{Digit}\\p{IsAlphabetic}][-_.\\p{Digit}\\p{IsAlphabetic}]*)))", tn));
        }
    }

    @Test
    public void testGetMaxFileSize() {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        Assert.assertEquals((long)-1L, (long)desc.getMaxFileSize());
        desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setMaxFileSize(1111L).build();
        Assert.assertEquals((long)1111L, (long)desc.getMaxFileSize());
    }

    @Test
    public void testGetMemStoreFlushSize() {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        Assert.assertEquals((long)-1L, (long)desc.getMemStoreFlushSize());
        desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setMemStoreFlushSize(1111L).build();
        Assert.assertEquals((long)1111L, (long)desc.getMemStoreFlushSize());
    }

    @Test
    public void testClassMethodsAreBuilderStyle() {
        BuilderStyleTest.assertClassesAreBuilderStyle(TableDescriptorBuilder.class);
    }

    @Test
    public void testModifyFamily() {
        byte[] familyName = Bytes.toBytes((String)"cf");
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setBlocksize(1000).setDFSReplication((short)3).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(hcd).build();
        Assert.assertEquals((long)1000L, (long)htd.getColumnFamily(familyName).getBlocksize());
        Assert.assertEquals((long)3L, (long)htd.getColumnFamily(familyName).getDFSReplication());
        hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setBlocksize(2000).setDFSReplication((short)1).build();
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).modifyColumnFamily(hcd).build();
        Assert.assertEquals((long)2000L, (long)htd.getColumnFamily(familyName).getBlocksize());
        Assert.assertEquals((long)1L, (long)htd.getColumnFamily(familyName).getDFSReplication());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testModifyInexistentFamily() {
        byte[] familyName = Bytes.toBytes((String)"cf");
        HColumnDescriptor hcd = new HColumnDescriptor(familyName);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).modifyColumnFamily((ColumnFamilyDescriptor)hcd).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddDuplicateFamilies() {
        byte[] familyName = Bytes.toBytes((String)"cf");
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setBlocksize(1000).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(hcd).build();
        Assert.assertEquals((long)1000L, (long)htd.getColumnFamily(familyName).getBlocksize());
        hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setBlocksize(2000).build();
        TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setColumnFamily(hcd).build();
    }

    @Test
    public void testPriority() {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setPriority(42).build();
        Assert.assertEquals((long)42L, (long)htd.getPriority());
    }

    @Test
    public void testStringCustomizedValues() {
        byte[] familyName = Bytes.toBytes((String)"cf");
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setBlocksize(1000).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(hcd).setDurability(Durability.ASYNC_WAL).build();
        Assert.assertEquals((Object)"'testStringCustomizedValues', {TABLE_ATTRIBUTES => {DURABILITY => 'ASYNC_WAL'}}, {NAME => 'cf', BLOCKSIZE => '1000'}", (Object)htd.toStringCustomizedValues());
    }
}

