/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.util.PoolMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class PoolMapTestBase {
    protected PoolMap<String, String> poolMap;
    protected static final int POOL_SIZE = 3;

    @Before
    public void setUp() throws Exception {
        this.poolMap = new PoolMap(this.getPoolType(), 3);
    }

    @After
    public void tearDown() throws Exception {
        this.poolMap.clear();
    }

    protected abstract PoolMap.PoolType getPoolType();

    protected void runThread(final String randomKey, final String randomValue, final String expectedValue) throws InterruptedException {
        final AtomicBoolean matchFound = new AtomicBoolean(false);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                PoolMapTestBase.this.poolMap.put((Object)randomKey, (Object)randomValue);
                String actualValue = (String)PoolMapTestBase.this.poolMap.get((Object)randomKey);
                matchFound.set(expectedValue == null ? actualValue == null : expectedValue.equals(actualValue));
            }
        });
        thread.start();
        thread.join();
        Assert.assertTrue((boolean)matchFound.get());
    }
}

