/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.hbase.util.PoolMapTestBase;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestThreadLocalPoolMap
extends PoolMapTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThreadLocalPoolMap.class);

    @Override
    protected PoolMap.PoolType getPoolType() {
        return PoolMap.PoolType.ThreadLocal;
    }

    @Test
    public void testSingleThreadedClient() throws InterruptedException, ExecutionException {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        String randomKey = String.valueOf(((Random)rand).nextInt());
        String randomValue = String.valueOf(((Random)rand).nextInt());
        this.runThread(randomKey, randomValue, randomValue);
        Assert.assertEquals((long)1L, (long)this.poolMap.size((Object)randomKey));
    }

    @Test
    public void testMultiThreadedClients() throws InterruptedException, ExecutionException {
        String randomValue;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 3; ++i) {
            String randomKey = String.valueOf(((Random)rand).nextInt());
            randomValue = String.valueOf(((Random)rand).nextInt());
            this.runThread(randomKey, randomValue, randomValue);
            Assert.assertEquals((long)1L, (long)this.poolMap.size((Object)randomKey));
        }
        String randomKey = String.valueOf(((Random)rand).nextInt());
        for (int i = 0; i < 3; ++i) {
            randomValue = String.valueOf(((Random)rand).nextInt());
            this.runThread(randomKey, randomValue, randomValue);
            Assert.assertEquals((long)(i + 1), (long)this.poolMap.size((Object)randomKey));
        }
    }

    @Test
    public void testPoolCap() throws InterruptedException, ExecutionException {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        String randomKey = String.valueOf(((Random)rand).nextInt());
        for (int i = 0; i < 6; ++i) {
            String randomValue = String.valueOf(((Random)rand).nextInt());
            this.runThread(randomKey, randomValue, randomValue);
        }
        Assert.assertEquals((long)6L, (long)this.poolMap.size((Object)randomKey));
    }
}

