/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import ch.cern.hbase.thirdparty.com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Public
public class HRegionInfo
implements RegionInfo,
Comparable<HRegionInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(HRegionInfo.class);
    public static final String ENCODED_REGION_NAME_REGEX = "(?:[a-f0-9]+)";
    private static final int MAX_REPLICA_ID = 65535;
    private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
    private boolean offLine = false;
    private long regionId = -1L;
    private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
    private boolean split = false;
    private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
    private int hashCode = -1;
    public static final String NO_HASH = null;
    private String encodedName = null;
    private byte[] encodedNameAsBytes = null;
    private int replicaId = 0;
    private TableName tableName = null;
    static final String DISPLAY_KEYS_KEY = "hbase.display.keys";
    public static final byte[] HIDDEN_END_KEY = RegionInfoDisplay.HIDDEN_END_KEY;
    public static final byte[] HIDDEN_START_KEY = RegionInfoDisplay.HIDDEN_START_KEY;
    public static final HRegionInfo FIRST_META_REGIONINFO = new HRegionInfo(1L, TableName.META_TABLE_NAME);

    @Deprecated
    public static String encodeRegionName(byte[] regionName) {
        return RegionInfo.encodeRegionName(regionName);
    }

    @Override
    public String getShortNameToLog() {
        return HRegionInfo.prettyPrint(this.getEncodedName());
    }

    @Deprecated
    public static String getShortNameToLog(HRegionInfo ... hris) {
        return RegionInfo.getShortNameToLog(Arrays.asList(hris));
    }

    @Deprecated
    public static String getShortNameToLog(List<HRegionInfo> hris) {
        return RegionInfo.getShortNameToLog(hris.stream().collect(Collectors.toList()));
    }

    @Deprecated
    @InterfaceAudience.Private
    public static String prettyPrint(String encodedRegionName) {
        return RegionInfo.prettyPrint(encodedRegionName);
    }

    private void setHashCode() {
        int result = Arrays.hashCode(this.regionName);
        result = (int)((long)result ^ this.regionId);
        result ^= Arrays.hashCode(this.startKey);
        result ^= Arrays.hashCode(this.endKey);
        result ^= Boolean.valueOf(this.offLine).hashCode();
        result ^= Arrays.hashCode(this.tableName.getName());
        this.hashCode = result ^= this.replicaId;
    }

    private HRegionInfo(long regionId, TableName tableName) {
        this(regionId, tableName, 0);
    }

    public HRegionInfo(long regionId, TableName tableName, int replicaId) {
        this.regionId = regionId;
        this.tableName = tableName;
        this.replicaId = replicaId;
        this.regionName = HRegionInfo.createRegionName(tableName, null, regionId, replicaId, false);
        this.setHashCode();
    }

    public HRegionInfo(TableName tableName) {
        this(tableName, null, null);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
        this(tableName, startKey, endKey, false);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, System.currentTimeMillis());
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, regionid, 0);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid, int replicaId) throws IllegalArgumentException {
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        this.tableName = tableName;
        this.offLine = false;
        this.regionId = regionid;
        this.replicaId = replicaId;
        if (this.replicaId > 65535) {
            throw new IllegalArgumentException("ReplicaId cannot be greater than65535");
        }
        this.regionName = HRegionInfo.createRegionName(this.tableName, startKey, this.regionId, replicaId, true);
        this.split = split;
        this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
        this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
        this.tableName = tableName;
        this.setHashCode();
    }

    public HRegionInfo(RegionInfo other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
        this.tableName = other.getTable();
        this.replicaId = other.getReplicaId();
    }

    public HRegionInfo(HRegionInfo other, int replicaId) {
        this(other);
        this.replicaId = replicaId;
        this.setHashCode();
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, Long.toString(regionid), newFormat);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] createRegionName(TableName tableName, byte[] startKey, String id, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, Bytes.toBytes((String)id), newFormat);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, int replicaId, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, Bytes.toBytes((String)Long.toString(regionid)), replicaId, newFormat);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, id, 0, newFormat);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, int replicaId, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, id, replicaId, newFormat);
    }

    @Deprecated
    public static TableName getTable(byte[] regionName) {
        return RegionInfo.getTable(regionName);
    }

    @Deprecated
    public static byte[] getStartKey(byte[] regionName) throws IOException {
        return RegionInfo.getStartKey(regionName);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        return RegionInfo.parseRegionName(regionName);
    }

    @Deprecated
    public static boolean isEncodedRegionName(byte[] regionName) throws IOException {
        return RegionInfo.isEncodedRegionName(regionName);
    }

    @Override
    public long getRegionId() {
        return this.regionId;
    }

    @Override
    public byte[] getRegionName() {
        return this.regionName;
    }

    @Override
    public String getRegionNameAsString() {
        if (RegionInfo.hasEncodedName(this.regionName)) {
            return Bytes.toStringBinary((byte[])this.regionName);
        }
        return Bytes.toStringBinary((byte[])this.regionName) + "." + this.getEncodedName();
    }

    @Override
    public synchronized String getEncodedName() {
        if (this.encodedName == null) {
            this.encodedName = RegionInfo.encodeRegionName(this.regionName);
        }
        return this.encodedName;
    }

    @Override
    public synchronized byte[] getEncodedNameAsBytes() {
        if (this.encodedNameAsBytes == null) {
            this.encodedNameAsBytes = Bytes.toBytes((String)this.getEncodedName());
        }
        return this.encodedNameAsBytes;
    }

    @Override
    public byte[] getStartKey() {
        return this.startKey;
    }

    @Override
    public byte[] getEndKey() {
        return this.endKey;
    }

    @Override
    public TableName getTable() {
        if (this.tableName == null || this.tableName.getName().length == 0) {
            this.tableName = HRegionInfo.getTable(this.getRegionName());
        }
        return this.tableName;
    }

    @Override
    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        if (Bytes.compareTo((byte[])rangeStartKey, (byte[])rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])rangeStartKey) + " > " + Bytes.toStringBinary((byte[])rangeEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo((byte[])rangeStartKey, (byte[])this.startKey) >= 0;
        boolean lastKeyInRange = Bytes.compareTo((byte[])rangeEndKey, (byte[])this.endKey) < 0 || Bytes.equals((byte[])this.endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    @Override
    public boolean containsRow(byte[] row) {
        return Bytes.compareTo((byte[])row, (byte[])this.startKey) >= 0 && (Bytes.compareTo((byte[])row, (byte[])this.endKey) < 0 || Bytes.equals((byte[])this.endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY));
    }

    public boolean isMetaTable() {
        return this.isMetaRegion();
    }

    @Override
    public boolean isMetaRegion() {
        return this.tableName.equals((Object)FIRST_META_REGIONINFO.getTable());
    }

    public boolean isSystemTable() {
        return this.tableName.isSystemTable();
    }

    @Override
    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    @Override
    public boolean isOffline() {
        return this.offLine;
    }

    public void setOffline(boolean offLine) {
        this.offLine = offLine;
    }

    @Override
    public boolean isSplitParent() {
        if (!this.isSplit()) {
            return false;
        }
        if (!this.isOffline()) {
            LOG.warn("Region is split but NOT offline: " + this.getRegionNameAsString());
        }
        return true;
    }

    @Override
    public int getReplicaId() {
        return this.replicaId;
    }

    public String toString() {
        return "{ENCODED => " + this.getEncodedName() + ", " + "NAME" + " => '" + Bytes.toStringBinary((byte[])this.regionName) + "', STARTKEY => '" + Bytes.toStringBinary((byte[])this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary((byte[])this.endKey) + "'" + (this.isOffline() ? ", OFFLINE => true" : "") + (this.isSplit() ? ", SPLIT => true" : "") + (this.replicaId > 0 ? ", REPLICA_ID => " + this.replicaId : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionInfo)) {
            return false;
        }
        return this.compareTo((HRegionInfo)o) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(HRegionInfo o) {
        return RegionInfo.COMPARATOR.compare(this, o);
    }

    @Deprecated
    public KeyValue.KVComparator getComparator() {
        return this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR;
    }

    HBaseProtos.RegionInfo convert() {
        return HRegionInfo.convert(this);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static HBaseProtos.RegionInfo convert(HRegionInfo info) {
        return ProtobufUtil.toRegionInfo(info);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static HRegionInfo convert(HBaseProtos.RegionInfo proto) {
        HRegionInfo hri;
        RegionInfo ri = ProtobufUtil.toRegionInfo(proto);
        if (ri.isMetaRegion()) {
            hri = ri.getReplicaId() == 0 ? FIRST_META_REGIONINFO : new HRegionInfo(ri.getRegionId(), ri.getTable(), ri.getReplicaId());
        } else {
            hri = new HRegionInfo(ri.getTable(), ri.getStartKey(), ri.getEndKey(), ri.isSplit(), ri.getRegionId(), ri.getReplicaId());
            if (proto.hasOffline()) {
                hri.setOffline(proto.getOffline());
            }
        }
        return hri;
    }

    @Deprecated
    public byte[] toByteArray() {
        return RegionInfo.toByteArray(this);
    }

    @Deprecated
    public static HRegionInfo parseFromOrNull(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(bytes, 0, bytes.length);
    }

    @Deprecated
    public static HRegionInfo parseFromOrNull(byte[] bytes, int offset, int len) {
        if (bytes == null || len <= 0) {
            return null;
        }
        try {
            return HRegionInfo.parseFrom(bytes, offset, len);
        }
        catch (DeserializationException e) {
            return null;
        }
    }

    public static HRegionInfo parseFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            return null;
        }
        return HRegionInfo.parseFrom(bytes, 0, bytes.length);
    }

    @Deprecated
    public static HRegionInfo parseFrom(byte[] bytes, int offset, int len) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes, offset, len)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen + offset, len - pblen);
                HBaseProtos.RegionInfo ri = builder.build();
                return HRegionInfo.convert(ri);
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        throw new DeserializationException("PB encoded HRegionInfo expected");
    }

    @Deprecated
    public byte[] toDelimitedByteArray() throws IOException {
        return RegionInfo.toDelimitedByteArray((RegionInfo)this);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static String getDescriptiveNameFromRegionStateForDisplay(RegionState state, Configuration conf) {
        return RegionInfoDisplay.getDescriptiveNameFromRegionStateForDisplay(state, conf);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] getEndKeyForDisplay(HRegionInfo hri, Configuration conf) {
        return RegionInfoDisplay.getEndKeyForDisplay(hri, conf);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] getStartKeyForDisplay(HRegionInfo hri, Configuration conf) {
        return RegionInfoDisplay.getStartKeyForDisplay(hri, conf);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static String getRegionNameAsStringForDisplay(HRegionInfo hri, Configuration conf) {
        return RegionInfoDisplay.getRegionNameAsStringForDisplay(hri, conf);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] getRegionNameForDisplay(HRegionInfo hri, Configuration conf) {
        return RegionInfoDisplay.getRegionNameForDisplay(hri, conf);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static HRegionInfo parseFrom(DataInputStream in) throws IOException {
        int read;
        int pblen = ProtobufUtil.lengthOfPBMagic();
        byte[] pbuf = new byte[pblen];
        if (in.markSupported()) {
            in.mark(pblen);
        }
        if ((read = in.read(pbuf)) != pblen) {
            throw new IOException("read=" + read + ", wanted=" + pblen);
        }
        if (ProtobufUtil.isPBMagicPrefix(pbuf)) {
            return HRegionInfo.convert(HBaseProtos.RegionInfo.parseDelimitedFrom((InputStream)in));
        }
        throw new IOException("PB encoded HRegionInfo expected");
    }

    @Deprecated
    @InterfaceAudience.Private
    public static byte[] toDelimitedByteArray(HRegionInfo ... infos) throws IOException {
        return RegionInfo.toDelimitedByteArray(infos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static List<HRegionInfo> parseDelimitedFrom(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("Can't build an object with empty bytes array");
        }
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        try (DataInputBuffer in = new DataInputBuffer();){
            in.reset(bytes, offset, length);
            while (in.available() > 0) {
                HRegionInfo hri = HRegionInfo.parseFrom((DataInputStream)in);
                hris.add(hri);
            }
        }
        return hris;
    }

    @Deprecated
    public static boolean areAdjacent(HRegionInfo regionA, HRegionInfo regionB) {
        return RegionInfo.areAdjacent(regionA, regionB);
    }
}

