/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.protobuf.RpcController;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MasterCoprocessorRpcChannelImpl
implements RpcChannel {
    AsyncRpcRetryingCallerFactory.MasterRequestCallerBuilder<Message> callerBuilder;

    MasterCoprocessorRpcChannelImpl(AsyncRpcRetryingCallerFactory.MasterRequestCallerBuilder<Message> callerBuilder) {
        this.callerBuilder = callerBuilder;
    }

    private CompletableFuture<Message> rpcCall(Descriptors.MethodDescriptor method, Message request, final Message responsePrototype, final HBaseRpcController controller, MasterProtos.MasterService.Interface stub) {
        final CompletableFuture<Message> future = new CompletableFuture<Message>();
        ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request);
        stub.execMasterService((RpcController)controller, csr, (ch.cern.hbase.thirdparty.com.google.protobuf.RpcCallback)new ch.cern.hbase.thirdparty.com.google.protobuf.RpcCallback<ClientProtos.CoprocessorServiceResponse>(){

            public void run(ClientProtos.CoprocessorServiceResponse resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(CoprocessorRpcUtils.getResponse(resp, responsePrototype));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    public void callMethod(Descriptors.MethodDescriptor method, com.google.protobuf.RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
        FutureUtils.addListener(this.callerBuilder.action((c, s) -> this.rpcCall(method, request, responsePrototype, c, s)).call(), (r, e) -> {
            if (e != null) {
                ((ClientCoprocessorRpcController)controller).setFailed((Throwable)e);
            }
            done.run(r);
        });
    }
}

