/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RequestController;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class SimpleRequestController
implements RequestController {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRequestController.class);
    public static final String HBASE_CLIENT_MAX_PERREQUEST_HEAPSIZE = "hbase.client.max.perrequest.heapsize";
    @VisibleForTesting
    static final long DEFAULT_HBASE_CLIENT_MAX_PERREQUEST_HEAPSIZE = 0x400000L;
    public static final String HBASE_CLIENT_MAX_PERREQUEST_ROWS = "hbase.client.max.perrequest.rows";
    @VisibleForTesting
    static final long DEFAULT_HBASE_CLIENT_MAX_PERREQUEST_ROWS = 2048L;
    public static final String HBASE_CLIENT_MAX_SUBMIT_HEAPSIZE = "hbase.client.max.submit.heapsize";
    @VisibleForTesting
    static final long DEFAULT_HBASE_CLIENT_MAX_SUBMIT_HEAPSIZE = 0x400000L;
    @VisibleForTesting
    final AtomicLong tasksInProgress = new AtomicLong(0L);
    @VisibleForTesting
    final ConcurrentMap<byte[], AtomicInteger> taskCounterPerRegion = new ConcurrentSkipListMap<byte[], AtomicInteger>(Bytes.BYTES_COMPARATOR);
    @VisibleForTesting
    final ConcurrentMap<ServerName, AtomicInteger> taskCounterPerServer = new ConcurrentHashMap<ServerName, AtomicInteger>();
    private final int maxTotalConcurrentTasks;
    private final long maxHeapSizePerRequest;
    private final long maxRowsPerRequest;
    private final long maxHeapSizeSubmit;
    @VisibleForTesting
    final int maxConcurrentTasksPerRegion;
    @VisibleForTesting
    final int maxConcurrentTasksPerServer;
    private final int thresholdToLogUndoneTaskDetails;
    public static final String THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS = "hbase.client.threshold.log.details";
    private static final int DEFAULT_THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS = 10;
    public static final String THRESHOLD_TO_LOG_REGION_DETAILS = "hbase.client.threshold.log.region.details";
    private static final int DEFAULT_THRESHOLD_TO_LOG_REGION_DETAILS = 2;
    private final int thresholdToLogRegionDetails;

    SimpleRequestController(Configuration conf) {
        this.maxTotalConcurrentTasks = SimpleRequestController.checkAndGet(conf, "hbase.client.max.total.tasks", 100);
        this.maxConcurrentTasksPerServer = SimpleRequestController.checkAndGet(conf, "hbase.client.max.perserver.tasks", 2);
        this.maxConcurrentTasksPerRegion = SimpleRequestController.checkAndGet(conf, "hbase.client.max.perregion.tasks", 1);
        this.maxHeapSizePerRequest = SimpleRequestController.checkAndGet(conf, HBASE_CLIENT_MAX_PERREQUEST_HEAPSIZE, 0x400000L);
        this.maxRowsPerRequest = SimpleRequestController.checkAndGet(conf, HBASE_CLIENT_MAX_PERREQUEST_ROWS, 2048L);
        this.maxHeapSizeSubmit = SimpleRequestController.checkAndGet(conf, HBASE_CLIENT_MAX_SUBMIT_HEAPSIZE, 0x400000L);
        this.thresholdToLogUndoneTaskDetails = conf.getInt(THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS, 10);
        this.thresholdToLogRegionDetails = conf.getInt(THRESHOLD_TO_LOG_REGION_DETAILS, 2);
    }

    private static int checkAndGet(Configuration conf, String key, int defaultValue) {
        int value = conf.getInt(key, defaultValue);
        if (value <= 0) {
            throw new IllegalArgumentException(key + "=" + value);
        }
        return value;
    }

    private static long checkAndGet(Configuration conf, String key, long defaultValue) {
        long value = conf.getLong(key, defaultValue);
        if (value <= 0L) {
            throw new IllegalArgumentException(key + "=" + value);
        }
        return value;
    }

    @VisibleForTesting
    static RequestController.Checker newChecker(final List<RowChecker> checkers) {
        return new RequestController.Checker(){
            private boolean isEnd = false;

            @Override
            public RequestController.ReturnCode canTakeRow(HRegionLocation loc, Row row) {
                if (this.isEnd) {
                    return RequestController.ReturnCode.END;
                }
                long heapSizeOfRow = row instanceof Mutation ? ((Mutation)row).heapSize() : 0L;
                RequestController.ReturnCode code = RequestController.ReturnCode.INCLUDE;
                for (RowChecker checker : checkers) {
                    switch (checker.canTakeOperation(loc, heapSizeOfRow)) {
                        case END: {
                            this.isEnd = true;
                            code = RequestController.ReturnCode.END;
                            break;
                        }
                        case SKIP: {
                            code = RequestController.ReturnCode.SKIP;
                            break;
                        }
                    }
                    if (code != RequestController.ReturnCode.END) continue;
                    break;
                }
                for (RowChecker checker : checkers) {
                    checker.notifyFinal(code, loc, heapSizeOfRow);
                }
                return code;
            }

            @Override
            public void reset() throws InterruptedIOException {
                this.isEnd = false;
                InterruptedIOException e = null;
                for (RowChecker checker : checkers) {
                    try {
                        checker.reset();
                    }
                    catch (InterruptedIOException ex) {
                        e = ex;
                    }
                }
                if (e != null) {
                    throw e;
                }
            }
        };
    }

    @Override
    public RequestController.Checker newChecker() {
        ArrayList<RowChecker> checkers = new ArrayList<RowChecker>(4);
        checkers.add(new TaskCountChecker(this.maxTotalConcurrentTasks, this.maxConcurrentTasksPerServer, this.maxConcurrentTasksPerRegion, this.tasksInProgress, this.taskCounterPerServer, this.taskCounterPerRegion));
        checkers.add(new RequestHeapSizeChecker(this.maxHeapSizePerRequest));
        checkers.add(new SubmittedSizeChecker(this.maxHeapSizeSubmit));
        checkers.add(new RequestRowsChecker(this.maxRowsPerRequest));
        return SimpleRequestController.newChecker(checkers);
    }

    @Override
    public void incTaskCounters(Collection<byte[]> regions, ServerName sn) {
        this.tasksInProgress.incrementAndGet();
        ((AtomicInteger)ConcurrentMapUtils.computeIfAbsent(this.taskCounterPerServer, (Object)sn, AtomicInteger::new)).incrementAndGet();
        regions.forEach(regBytes -> ((AtomicInteger)ConcurrentMapUtils.computeIfAbsent(this.taskCounterPerRegion, (Object)regBytes, AtomicInteger::new)).incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decTaskCounters(Collection<byte[]> regions, ServerName sn) {
        regions.forEach(regBytes -> {
            AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(regBytes);
            regionCnt.decrementAndGet();
        });
        ((AtomicInteger)this.taskCounterPerServer.get(sn)).decrementAndGet();
        this.tasksInProgress.decrementAndGet();
        AtomicLong atomicLong = this.tasksInProgress;
        synchronized (atomicLong) {
            this.tasksInProgress.notifyAll();
        }
    }

    @Override
    public long getNumberOfTasksInProgress() {
        return this.tasksInProgress.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForMaximumCurrentTasks(long max, long id, int periodToTrigger, Consumer<Long> trigger) throws InterruptedIOException {
        long currentInProgress;
        assert (max >= 0L);
        long lastLog = EnvironmentEdgeManager.currentTime();
        long oldInProgress = Long.MAX_VALUE;
        while ((currentInProgress = this.tasksInProgress.get()) > max) {
            long now2;
            if (oldInProgress != currentInProgress && (now2 = EnvironmentEdgeManager.currentTime()) > lastLog + (long)periodToTrigger) {
                lastLog = now2;
                if (trigger != null) {
                    trigger.accept(currentInProgress);
                }
                this.logDetailsOfUndoneTasks(currentInProgress);
            }
            oldInProgress = currentInProgress;
            try {
                AtomicLong now2 = this.tasksInProgress;
                synchronized (now2) {
                    if (this.tasksInProgress.get() == oldInProgress) {
                        this.tasksInProgress.wait(10L);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("#" + id + ", interrupted. currentNumberOfTask=" + currentInProgress);
            }
        }
    }

    private void logDetailsOfUndoneTasks(long taskInProgress) {
        if (taskInProgress <= (long)this.thresholdToLogUndoneTaskDetails) {
            ArrayList servers = new ArrayList();
            for (Map.Entry entry : this.taskCounterPerServer.entrySet()) {
                if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
                servers.add(entry.getKey());
            }
            LOG.info("Left over " + taskInProgress + " task(s) are processed on server(s): " + servers);
        }
        if (taskInProgress <= (long)this.thresholdToLogRegionDetails) {
            ArrayList<String> regions = new ArrayList<String>();
            for (Map.Entry entry : this.taskCounterPerRegion.entrySet()) {
                if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
                regions.add(Bytes.toString((byte[])((byte[])entry.getKey())));
            }
            LOG.info("Regions against which left over task(s) are processed: " + regions);
        }
    }

    @Override
    public void waitForFreeSlot(long id, int periodToTrigger, Consumer<Long> trigger) throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(this.maxTotalConcurrentTasks - 1, id, periodToTrigger, trigger);
    }

    @VisibleForTesting
    static interface RowChecker {
        public RequestController.ReturnCode canTakeOperation(HRegionLocation var1, long var2);

        public void notifyFinal(RequestController.ReturnCode var1, HRegionLocation var2, long var3);

        public void reset() throws InterruptedIOException;
    }

    @VisibleForTesting
    static class RequestHeapSizeChecker
    implements RowChecker {
        private final long maxHeapSizePerRequest;
        private final Map<ServerName, Long> serverRequestSizes = new HashMap<ServerName, Long>();

        RequestHeapSizeChecker(long maxHeapSizePerRequest) {
            this.maxHeapSizePerRequest = maxHeapSizePerRequest;
        }

        @Override
        public void reset() {
            this.serverRequestSizes.clear();
        }

        @Override
        public RequestController.ReturnCode canTakeOperation(HRegionLocation loc, long heapSizeOfRow) {
            long currentRequestSize;
            long l = currentRequestSize = this.serverRequestSizes.containsKey(loc.getServerName()) ? this.serverRequestSizes.get(loc.getServerName()) : 0L;
            if (currentRequestSize == 0L || currentRequestSize + heapSizeOfRow <= this.maxHeapSizePerRequest) {
                return RequestController.ReturnCode.INCLUDE;
            }
            return RequestController.ReturnCode.SKIP;
        }

        @Override
        public void notifyFinal(RequestController.ReturnCode code, HRegionLocation loc, long heapSizeOfRow) {
            if (code == RequestController.ReturnCode.INCLUDE) {
                long currentRequestSize = this.serverRequestSizes.containsKey(loc.getServerName()) ? this.serverRequestSizes.get(loc.getServerName()) : 0L;
                this.serverRequestSizes.put(loc.getServerName(), currentRequestSize + heapSizeOfRow);
            }
        }
    }

    @VisibleForTesting
    static class RequestRowsChecker
    implements RowChecker {
        private final long maxRowsPerRequest;
        private final Map<ServerName, Long> serverRows = new HashMap<ServerName, Long>();

        RequestRowsChecker(long maxRowsPerRequest) {
            this.maxRowsPerRequest = maxRowsPerRequest;
        }

        @Override
        public void reset() {
            this.serverRows.clear();
        }

        @Override
        public RequestController.ReturnCode canTakeOperation(HRegionLocation loc, long heapSizeOfRow) {
            long currentRows;
            long l = currentRows = this.serverRows.containsKey(loc.getServerName()) ? this.serverRows.get(loc.getServerName()) : 0L;
            if (currentRows == 0L || currentRows < this.maxRowsPerRequest) {
                return RequestController.ReturnCode.INCLUDE;
            }
            return RequestController.ReturnCode.SKIP;
        }

        @Override
        public void notifyFinal(RequestController.ReturnCode code, HRegionLocation loc, long heapSizeOfRow) {
            if (code == RequestController.ReturnCode.INCLUDE) {
                long currentRows = this.serverRows.containsKey(loc.getServerName()) ? this.serverRows.get(loc.getServerName()) : 0L;
                this.serverRows.put(loc.getServerName(), currentRows + 1L);
            }
        }
    }

    @VisibleForTesting
    static class TaskCountChecker
    implements RowChecker {
        private static final long MAX_WAITING_TIME = 1000L;
        private final Set<HRegionInfo> regionsIncluded = new HashSet<HRegionInfo>();
        private final Set<ServerName> serversIncluded = new HashSet<ServerName>();
        private final int maxConcurrentTasksPerRegion;
        private final int maxTotalConcurrentTasks;
        private final int maxConcurrentTasksPerServer;
        private final Map<byte[], AtomicInteger> taskCounterPerRegion;
        private final Map<ServerName, AtomicInteger> taskCounterPerServer;
        private final Set<byte[]> busyRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        private final AtomicLong tasksInProgress;

        TaskCountChecker(int maxTotalConcurrentTasks, int maxConcurrentTasksPerServer, int maxConcurrentTasksPerRegion, AtomicLong tasksInProgress, Map<ServerName, AtomicInteger> taskCounterPerServer, Map<byte[], AtomicInteger> taskCounterPerRegion) {
            this.maxTotalConcurrentTasks = maxTotalConcurrentTasks;
            this.maxConcurrentTasksPerRegion = maxConcurrentTasksPerRegion;
            this.maxConcurrentTasksPerServer = maxConcurrentTasksPerServer;
            this.taskCounterPerRegion = taskCounterPerRegion;
            this.taskCounterPerServer = taskCounterPerServer;
            this.tasksInProgress = tasksInProgress;
        }

        @Override
        public void reset() throws InterruptedIOException {
            this.waitForRegion();
            this.regionsIncluded.clear();
            this.serversIncluded.clear();
            this.busyRegions.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForRegion() throws InterruptedIOException {
            if (this.busyRegions.isEmpty()) {
                return;
            }
            EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
            long start = ee.currentTime();
            while (ee.currentTime() - start <= 1000L) {
                for (byte[] region : this.busyRegions) {
                    AtomicInteger count = this.taskCounterPerRegion.get(region);
                    if (count != null && count.get() >= this.maxConcurrentTasksPerRegion) continue;
                    return;
                }
                try {
                    AtomicLong atomicLong = this.tasksInProgress;
                    synchronized (atomicLong) {
                        this.tasksInProgress.wait(10L);
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted. tasksInProgress=" + this.tasksInProgress);
                }
            }
        }

        @Override
        public RequestController.ReturnCode canTakeOperation(HRegionLocation loc, long heapSizeOfRow) {
            HRegionInfo regionInfo = loc.getRegionInfo();
            if (this.regionsIncluded.contains(regionInfo)) {
                return RequestController.ReturnCode.INCLUDE;
            }
            AtomicInteger regionCnt = this.taskCounterPerRegion.get(loc.getRegionInfo().getRegionName());
            if (regionCnt != null && regionCnt.get() >= this.maxConcurrentTasksPerRegion) {
                return RequestController.ReturnCode.SKIP;
            }
            int newServers = this.serversIncluded.size() + (this.serversIncluded.contains(loc.getServerName()) ? 0 : 1);
            if ((long)newServers + this.tasksInProgress.get() > (long)this.maxTotalConcurrentTasks) {
                return RequestController.ReturnCode.SKIP;
            }
            AtomicInteger serverCnt = this.taskCounterPerServer.get(loc.getServerName());
            if (serverCnt != null && serverCnt.get() >= this.maxConcurrentTasksPerServer) {
                return RequestController.ReturnCode.SKIP;
            }
            return RequestController.ReturnCode.INCLUDE;
        }

        @Override
        public void notifyFinal(RequestController.ReturnCode code, HRegionLocation loc, long heapSizeOfRow) {
            if (code == RequestController.ReturnCode.INCLUDE) {
                this.regionsIncluded.add(loc.getRegionInfo());
                this.serversIncluded.add(loc.getServerName());
            }
            this.busyRegions.add(loc.getRegionInfo().getRegionName());
        }
    }

    @VisibleForTesting
    static class SubmittedSizeChecker
    implements RowChecker {
        private final long maxHeapSizeSubmit;
        private long heapSize = 0L;

        SubmittedSizeChecker(long maxHeapSizeSubmit) {
            this.maxHeapSizeSubmit = maxHeapSizeSubmit;
        }

        @Override
        public RequestController.ReturnCode canTakeOperation(HRegionLocation loc, long heapSizeOfRow) {
            if (this.heapSize >= this.maxHeapSizeSubmit) {
                return RequestController.ReturnCode.END;
            }
            return RequestController.ReturnCode.INCLUDE;
        }

        @Override
        public void notifyFinal(RequestController.ReturnCode code, HRegionLocation loc, long heapSizeOfRow) {
            if (code == RequestController.ReturnCode.INCLUDE) {
                this.heapSize += heapSizeOfRow;
            }
        }

        @Override
        public void reset() {
            this.heapSize = 0L;
        }
    }
}

