/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import ch.cern.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class BigDecimalComparator
extends ByteArrayComparable {
    private BigDecimal bigDecimal;

    public BigDecimalComparator(BigDecimal value) {
        super(Bytes.toBytes((BigDecimal)value));
        this.bigDecimal = value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BigDecimalComparator)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BigDecimalComparator bdc = (BigDecimalComparator)((Object)obj);
        return this.bigDecimal.equals(bdc.bigDecimal);
    }

    public int hashCode() {
        return Objects.hash(this.bigDecimal);
    }

    public int compareTo(byte[] value, int offset, int length) {
        BigDecimal that = Bytes.toBigDecimal((byte[])value, (int)offset, (int)length);
        return this.bigDecimal.compareTo(that);
    }

    public int compareTo(ByteBuffer value, int offset, int length) {
        BigDecimal that = ByteBufferUtils.toBigDecimal((ByteBuffer)value, (int)offset, (int)length);
        return this.bigDecimal.compareTo(that);
    }

    public byte[] toByteArray() {
        ComparatorProtos.BigDecimalComparator.Builder builder = ComparatorProtos.BigDecimalComparator.newBuilder();
        builder.setComparable(ProtobufUtil.toByteArrayComparable(this.value));
        return builder.build().toByteArray();
    }

    public static BigDecimalComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BigDecimalComparator proto;
        try {
            proto = ComparatorProtos.BigDecimalComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new BigDecimalComparator(Bytes.toBigDecimal((byte[])proto.getComparable().getValue().toByteArray()));
    }

    boolean areSerializedFieldsEqual(BigDecimalComparator other) {
        if (other == this) {
            return true;
        }
        return super.areSerializedFieldsEqual((ByteArrayComparable)other);
    }
}

