/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import ch.cern.hbase.thirdparty.com.google.common.base.Preconditions;
import ch.cern.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import ch.cern.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class DependentColumnFilter
extends CompareFilter {
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    protected boolean dropDependentColumn;
    protected Set<Long> stampSet = new HashSet<Long>();

    @Deprecated
    public DependentColumnFilter(byte[] family, byte[] qualifier, boolean dropDependentColumn, CompareFilter.CompareOp valueCompareOp, ByteArrayComparable valueComparator) {
        this(family, qualifier, dropDependentColumn, CompareOperator.valueOf(valueCompareOp.name()), valueComparator);
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier, boolean dropDependentColumn, CompareOperator op, ByteArrayComparable valueComparator) {
        super(op, valueComparator);
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.dropDependentColumn = dropDependentColumn;
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier) {
        this(family, qualifier, false);
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier, boolean dropDependentColumn) {
        this(family, qualifier, dropDependentColumn, CompareFilter.CompareOp.NO_OP, null);
    }

    public byte[] getFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.columnQualifier;
    }

    public boolean dropDependentColumn() {
        return this.dropDependentColumn;
    }

    public boolean getDropDependentColumn() {
        return this.dropDependentColumn;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (!CellUtil.matchingColumn((Cell)c, (byte[])this.columnFamily, (byte[])this.columnQualifier)) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.comparator != null && this.compareValue(this.getCompareOperator(), this.comparator, c)) {
            return Filter.ReturnCode.SKIP;
        }
        this.stampSet.add(c.getTimestamp());
        if (this.dropDependentColumn) {
            return Filter.ReturnCode.SKIP;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public void filterRowCells(List<Cell> kvs) {
        kvs.removeIf(kv -> !this.stampSet.contains(kv.getTimestamp()));
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public boolean filterRow() {
        return false;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        return false;
    }

    @Override
    public void reset() {
        this.stampSet.clear();
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 2 || filterArguments.size() == 3 || filterArguments.size() == 5 ? 1 : 0) != 0, (String)"Expected 2, 3 or 5 but got: %s", (int)filterArguments.size());
        if (filterArguments.size() == 2) {
            byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
            byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
            return new DependentColumnFilter(family, qualifier);
        }
        if (filterArguments.size() == 3) {
            byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
            byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
            boolean dropDependentColumn = ParseFilter.convertByteArrayToBoolean(filterArguments.get(2));
            return new DependentColumnFilter(family, qualifier, dropDependentColumn);
        }
        if (filterArguments.size() == 5) {
            byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
            byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
            boolean dropDependentColumn = ParseFilter.convertByteArrayToBoolean(filterArguments.get(2));
            CompareOperator op = ParseFilter.createCompareOperator(filterArguments.get(3));
            ByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(4)));
            return new DependentColumnFilter(family, qualifier, dropDependentColumn, op, comparator);
        }
        throw new IllegalArgumentException("Expected 2, 3 or 5 but got: " + filterArguments.size());
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.DependentColumnFilter.Builder builder = FilterProtos.DependentColumnFilter.newBuilder();
        builder.setCompareFilter(super.convert());
        if (this.columnFamily != null) {
            builder.setColumnFamily(UnsafeByteOperations.unsafeWrap((byte[])this.columnFamily));
        }
        if (this.columnQualifier != null) {
            builder.setColumnQualifier(UnsafeByteOperations.unsafeWrap((byte[])this.columnQualifier));
        }
        builder.setDropDependentColumn(this.dropDependentColumn);
        return builder.build().toByteArray();
    }

    public static DependentColumnFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.DependentColumnFilter proto;
        try {
            proto = FilterProtos.DependentColumnFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        CompareOperator valueCompareOp = CompareOperator.valueOf(proto.getCompareFilter().getCompareOp().name());
        ByteArrayComparable valueComparator = null;
        try {
            if (proto.getCompareFilter().hasComparator()) {
                valueComparator = ProtobufUtil.toComparator(proto.getCompareFilter().getComparator());
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException((Throwable)ioe);
        }
        return new DependentColumnFilter(proto.hasColumnFamily() ? proto.getColumnFamily().toByteArray() : null, proto.hasColumnQualifier() ? proto.getColumnQualifier().toByteArray() : null, proto.getDropDependentColumn(), valueCompareOp, valueComparator);
    }

    @Override
    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependentColumnFilter)) {
            return false;
        }
        DependentColumnFilter other = (DependentColumnFilter)o;
        return other != null && super.areSerializedFieldsEqual(other) && Bytes.equals((byte[])this.getFamily(), (byte[])other.getFamily()) && Bytes.equals((byte[])this.getQualifier(), (byte[])other.getQualifier()) && this.dropDependentColumn() == other.dropDependentColumn();
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s, %s, %s, %s)", this.getClass().getSimpleName(), Bytes.toStringBinary((byte[])this.columnFamily), Bytes.toStringBinary((byte[])this.columnQualifier), this.dropDependentColumn, this.op.name(), this.comparator != null ? Bytes.toStringBinary((byte[])this.comparator.getValue()) : "null");
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{Bytes.hashCode((byte[])this.getFamily()), Bytes.hashCode((byte[])this.getQualifier()), this.dropDependentColumn(), this.getComparator(), this.getCompareOperator()});
    }
}

