/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import ch.cern.hbase.thirdparty.io.netty.channel.Channel;
import ch.cern.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import ch.cern.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import ch.cern.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import ch.cern.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcClient
extends AbstractRpcClient<NettyRpcConnection> {
    final EventLoopGroup group;
    final Class<? extends Channel> channelClass;
    private final boolean shutdownGroupWhenClose;

    public NettyRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics) {
        super(configuration, clusterId, localAddress, metrics);
        Pair<EventLoopGroup, Class<? extends Channel>> groupAndChannelClass = NettyRpcClientConfigHelper.getEventLoopConfig(this.conf);
        if (groupAndChannelClass == null) {
            this.group = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("IPC-NioEventLoopGroup", true, 10));
            this.channelClass = NioSocketChannel.class;
            this.shutdownGroupWhenClose = true;
        } else {
            this.group = (EventLoopGroup)groupAndChannelClass.getFirst();
            this.channelClass = (Class)groupAndChannelClass.getSecond();
            this.shutdownGroupWhenClose = false;
        }
    }

    NettyRpcClient(Configuration configuration) {
        this(configuration, "default-cluster", null, null);
    }

    @Override
    protected NettyRpcConnection createConnection(ConnectionId remoteId) throws IOException {
        return new NettyRpcConnection(this, remoteId);
    }

    @Override
    protected void closeInternal() {
        if (this.shutdownGroupWhenClose) {
            this.group.shutdownGracefully();
        }
    }
}

