/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import ch.cern.hbase.thirdparty.com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@InterfaceAudience.Private
public final class HBaseClassTestRule
implements TestRule {
    public static final Set<Class<?>> UNIT_TEST_CLASSES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Class[]{SmallTests.class, MediumTests.class, LargeTests.class}));
    private final Class<?> clazz;
    private final Timeout timeout;

    private HBaseClassTestRule(Class<?> clazz, Timeout timeout) {
        this.clazz = clazz;
        this.timeout = timeout;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private static long getTimeoutInSeconds(Class<?> clazz) {
        Category[] categories = (Category[])clazz.getAnnotationsByType(Category.class);
        if (categories.length == 1) {
            for (Class c : categories[0].value()) {
                if (UNIT_TEST_CLASSES.contains(c)) {
                    return TimeUnit.MINUTES.toSeconds(13L);
                }
                if (c != IntegrationTests.class) continue;
                return TimeUnit.MINUTES.toSeconds(Long.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException(clazz.getName() + " does not have SmallTests/MediumTests/LargeTests in @Category");
    }

    public static HBaseClassTestRule forClass(Class<?> clazz) {
        return new HBaseClassTestRule(clazz, Timeout.builder().withLookingForStuckThread(true).withTimeout(HBaseClassTestRule.getTimeoutInSeconds(clazz), TimeUnit.SECONDS).build());
    }

    public Statement apply(Statement base, Description description) {
        return this.timeout.apply(base, description);
    }
}

