/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import ch.cern.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHBaseConfiguration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseConfiguration.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHBaseConfiguration.class);
    private static HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testSubset() {
        Configuration conf = HBaseConfiguration.create();
        String prefix = "hbase.mapred.output.";
        conf.set("hbase.security.authentication", "kerberos");
        conf.set("hbase.regionserver.kerberos.principal", "hbasesource");
        HBaseConfiguration.setWithPrefix((Configuration)conf, (String)prefix, (Iterable)ImmutableMap.of((Object)"hbase.regionserver.kerberos.principal", (Object)"hbasedest", (Object)"", (Object)"shouldbemissing").entrySet());
        Configuration subsetConf = HBaseConfiguration.subset((Configuration)conf, (String)prefix);
        Assert.assertNull((Object)subsetConf.get(prefix + "hbase.regionserver.kerberos.principal"));
        Assert.assertEquals((Object)"hbasedest", (Object)subsetConf.get("hbase.regionserver.kerberos.principal"));
        Assert.assertNull((Object)subsetConf.get("hbase.security.authentication"));
        Assert.assertNull((Object)subsetConf.get(""));
        Configuration mergedConf = HBaseConfiguration.create((Configuration)conf);
        HBaseConfiguration.merge((Configuration)mergedConf, (Configuration)subsetConf);
        Assert.assertEquals((Object)"hbasedest", (Object)mergedConf.get("hbase.regionserver.kerberos.principal"));
        Assert.assertEquals((Object)"kerberos", (Object)mergedConf.get("hbase.security.authentication"));
        Assert.assertEquals((Object)"shouldbemissing", (Object)mergedConf.get(prefix));
    }

    @Test
    public void testGetPassword() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hadoop.security.credential.provider.path", "jceks://file" + new File(UTIL.getDataTestDir().toUri().getPath(), "foo.jks").getCanonicalPath());
        ReflectiveCredentialProviderClient client = new ReflectiveCredentialProviderClient();
        if (client.isHadoopCredentialProviderAvailable()) {
            char[] keyPass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
            char[] storePass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
            client.createEntry(conf, "ssl.keypass.alias", keyPass);
            client.createEntry(conf, "ssl.storepass.alias", storePass);
            String keypass = HBaseConfiguration.getPassword((Configuration)conf, (String)"ssl.keypass.alias", null);
            Assert.assertEquals((Object)keypass, (Object)new String(keyPass));
            String storepass = HBaseConfiguration.getPassword((Configuration)conf, (String)"ssl.storepass.alias", null);
            Assert.assertEquals((Object)storepass, (Object)new String(storePass));
        }
    }

    private static class ReflectiveCredentialProviderClient {
        public static final String HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME = "org.apache.hadoop.security.alias.JavaKeyStoreProvider$Factory";
        public static final String HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME = "getProviders";
        public static final String HADOOP_CRED_PROVIDER_CLASS_NAME = "org.apache.hadoop.security.alias.CredentialProvider";
        public static final String HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME = "getCredentialEntry";
        public static final String HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME = "getAliases";
        public static final String HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME = "createCredentialEntry";
        public static final String HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME = "flush";
        public static final String HADOOP_CRED_ENTRY_CLASS_NAME = "org.apache.hadoop.security.alias.CredentialProvider$CredentialEntry";
        public static final String HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME = "getCredential";
        public static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
        private static Object hadoopCredProviderFactory = null;
        private static Method getProvidersMethod = null;
        private static Method getCredentialEntryMethod = null;
        private static Method getCredentialMethod = null;
        private static Method createCredentialEntryMethod = null;
        private static Method flushMethod = null;
        private static Boolean hadoopClassesAvailable = null;

        private ReflectiveCredentialProviderClient() {
        }

        private boolean isHadoopCredentialProviderAvailable() {
            Class<?> hadoopCredProviderFactoryClz;
            if (null != hadoopClassesAvailable) {
                return hadoopClassesAvailable != false && null != getProvidersMethod && null != hadoopCredProviderFactory && null != getCredentialEntryMethod && null != getCredentialMethod;
            }
            hadoopClassesAvailable = false;
            try {
                hadoopCredProviderFactoryClz = Class.forName(HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            try {
                hadoopCredProviderFactory = hadoopCredProviderFactoryClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                return false;
            }
            try {
                Class<?> hadoopCredentialEntryClz;
                getProvidersMethod = this.loadMethod(hadoopCredProviderFactoryClz, HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, Configuration.class);
                Class<?> hadoopCredProviderClz = Class.forName(HADOOP_CRED_PROVIDER_CLASS_NAME);
                getCredentialEntryMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME, String.class);
                Method getAliasesMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, new Class[0]);
                createCredentialEntryMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME, String.class, char[].class);
                flushMethod = this.loadMethod(hadoopCredProviderClz, HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME, new Class[0]);
                try {
                    hadoopCredentialEntryClz = Class.forName(HADOOP_CRED_ENTRY_CLASS_NAME);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Failed to load class:" + e);
                    return false;
                }
                getCredentialMethod = this.loadMethod(hadoopCredentialEntryClz, HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME, new Class[0]);
            }
            catch (Exception e1) {
                return false;
            }
            hadoopClassesAvailable = true;
            LOG.info("Credential provider classes have been loaded and initialized successfully through reflection.");
            return true;
        }

        private Method loadMethod(Class<?> clz, String name, Class<?> ... classes) throws Exception {
            Method method;
            try {
                method = clz.getMethod(name, classes);
            }
            catch (SecurityException e) {
                Assert.fail((String)("security exception caught for: " + name + " in " + clz.getCanonicalName()));
                throw e;
            }
            catch (NoSuchMethodException e) {
                LOG.error("Failed to load the " + name + ": " + e);
                Assert.fail((String)("no such method: " + name + " in " + clz.getCanonicalName()));
                throw e;
            }
            return method;
        }

        protected List<Object> getCredentialProviders(Configuration conf) {
            Object providersObj;
            try {
                providersObj = getProvidersMethod.invoke(hadoopCredProviderFactory, conf);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("Failed to invoke: " + getProvidersMethod.getName() + ": " + e);
                return null;
            }
            try {
                return (List)providersObj;
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public void createEntry(Configuration conf, String name, char[] credential) throws Exception {
            if (!this.isHadoopCredentialProviderAvailable()) {
                return;
            }
            List<Object> providers = this.getCredentialProviders(conf);
            if (null == providers) {
                throw new IOException("Could not fetch any CredentialProviders, is the implementation available?");
            }
            Object provider = providers.get(0);
            this.createEntryInProvider(provider, name, credential);
        }

        private void createEntryInProvider(Object credentialProvider, String name, char[] credential) throws Exception {
            if (!this.isHadoopCredentialProviderAvailable()) {
                return;
            }
            try {
                createCredentialEntryMethod.invoke(credentialProvider, name, credential);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return;
            }
            flushMethod.invoke(credentialProvider, new Object[0]);
        }
    }
}

