/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import ch.cern.hbase.thirdparty.com.google.common.io.CountingInputStream;
import ch.cern.hbase.thirdparty.com.google.common.io.CountingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestKeyValueCodecWithTags {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestKeyValueCodecWithTags.class);

    @Test
    public void testKeyValueWithTag() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        KeyValueCodecWithTags codec = new KeyValueCodecWithTags();
        Codec.Encoder encoder = codec.getEncoder((OutputStream)dos);
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"1"), Long.MAX_VALUE, Bytes.toBytes((String)"1"), new Tag[]{new ArrayBackedTag(1, Bytes.toBytes((String)"teststring1")), new ArrayBackedTag(2, Bytes.toBytes((String)"teststring2"))});
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"2"), Long.MAX_VALUE, Bytes.toBytes((String)"2"), new Tag[]{new ArrayBackedTag(1, Bytes.toBytes((String)"teststring3"))});
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"3"), Long.MAX_VALUE, Bytes.toBytes((String)"3"), new Tag[]{new ArrayBackedTag(2, Bytes.toBytes((String)"teststring4")), new ArrayBackedTag(2, Bytes.toBytes((String)"teststring5")), new ArrayBackedTag(1, Bytes.toBytes((String)"teststring6"))});
        encoder.write((Cell)kv1);
        encoder.write((Cell)kv2);
        encoder.write((Cell)kv3);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder = codec.getDecoder((InputStream)dis);
        Assert.assertTrue((boolean)decoder.advance());
        Cell c = decoder.current();
        Assert.assertTrue((boolean)CellUtil.equals((Cell)c, (Cell)kv1));
        List tags = PrivateCellUtil.getTags((Cell)c);
        Assert.assertEquals((long)2L, (long)tags.size());
        Tag tag = (Tag)tags.get(0);
        Assert.assertEquals((long)1L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"teststring1"), (byte[])Tag.cloneValue((Tag)tag)));
        tag = (Tag)tags.get(1);
        Assert.assertEquals((long)2L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"teststring2"), (byte[])Tag.cloneValue((Tag)tag)));
        Assert.assertTrue((boolean)decoder.advance());
        c = decoder.current();
        Assert.assertTrue((boolean)CellUtil.equals((Cell)c, (Cell)kv2));
        tags = PrivateCellUtil.getTags((Cell)c);
        Assert.assertEquals((long)1L, (long)tags.size());
        tag = (Tag)tags.get(0);
        Assert.assertEquals((long)1L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"teststring3"), (byte[])Tag.cloneValue((Tag)tag)));
        Assert.assertTrue((boolean)decoder.advance());
        c = decoder.current();
        Assert.assertTrue((boolean)CellUtil.equals((Cell)c, (Cell)kv3));
        tags = PrivateCellUtil.getTags((Cell)c);
        Assert.assertEquals((long)3L, (long)tags.size());
        tag = (Tag)tags.get(0);
        Assert.assertEquals((long)2L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"teststring4"), (byte[])Tag.cloneValue((Tag)tag)));
        tag = (Tag)tags.get(1);
        Assert.assertEquals((long)2L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"teststring5"), (byte[])Tag.cloneValue((Tag)tag)));
        tag = (Tag)tags.get(2);
        Assert.assertEquals((long)1L, (long)tag.getType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"teststring6"), (byte[])Tag.cloneValue((Tag)tag)));
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }
}

