/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import ch.cern.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import ch.cern.hbase.thirdparty.org.apache.commons.cli.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractHBaseToolTest {
    TestTool tool;

    @Before
    public void setup() {
        this.tool = new TestTool();
        this.tool.setConf(HBaseConfiguration.create());
    }

    @Test
    public void testAllOptionsSet() throws Exception {
        String[] args = new String[]{"--required=foo", "--optional=bar", "--boolean"};
        int returnValue = this.tool.run(args);
        Assert.assertEquals((long)0L, (long)returnValue);
        Assert.assertEquals((Object)"foo", (Object)this.tool.requiredValue);
        Assert.assertEquals((Object)"bar", (Object)this.tool.optionalValue);
        Assert.assertTrue((boolean)this.tool.booleanValue);
    }

    @Test
    public void testOptionsNotSet() throws Exception {
        String[] args = new String[]{"--required=foo"};
        int returnValue = this.tool.run(args);
        Assert.assertEquals((long)0L, (long)returnValue);
        Assert.assertEquals((Object)"foo", (Object)this.tool.requiredValue);
        Assert.assertNull((Object)this.tool.optionalValue);
        Assert.assertFalse((boolean)this.tool.booleanValue);
    }

    @Test
    public void testMissingRequiredOption() throws Exception {
        String[] args = new String[]{};
        int returnValue = this.tool.run(args);
        Assert.assertEquals((long)1L, (long)returnValue);
    }

    @Test
    public void testFailureOnUnrecognizedOption() throws Exception {
        String[] args = new String[]{"--required=foo", "-asdfs"};
        int returnValue = this.tool.run(args);
        Assert.assertEquals((long)1L, (long)returnValue);
    }

    @Test
    public void testOldOptionsWork() throws Exception {
        String[] args = new String[]{"--required=foo", "-opt", "bar", "-bool"};
        int returnValue = this.tool.run(args);
        Assert.assertEquals((long)0L, (long)returnValue);
        Assert.assertEquals((Object)"foo", (Object)this.tool.requiredValue);
        Assert.assertEquals((Object)"bar", (Object)this.tool.optionalValue);
        Assert.assertTrue((boolean)this.tool.booleanValue);
    }

    @Test
    public void testNewOptionOverridesOldOption() throws Exception {
        String[] args = new String[]{"--required=foo", "--optional=baz", "-opt", "bar", "-bool"};
        int returnValue = this.tool.run(args);
        Assert.assertEquals((long)0L, (long)returnValue);
        Assert.assertEquals((Object)"foo", (Object)this.tool.requiredValue);
        Assert.assertEquals((Object)"baz", (Object)this.tool.optionalValue);
        Assert.assertTrue((boolean)this.tool.booleanValue);
    }

    private static class TestTool
    extends AbstractHBaseTool {
        String requiredValue;
        String optionalValue;
        boolean booleanValue;

        private TestTool() {
        }

        protected void addOptions() {
            this.addRequiredOption(Options.REQUIRED);
            this.addOption(Options.OPTIONAL);
            this.addOption(Options.BOOLEAN);
        }

        protected void processOptions(CommandLine cmd) {
            this.requiredValue = cmd.getOptionValue(Options.REQUIRED.getLongOpt());
            if (cmd.hasOption(Options.OPTIONAL.getLongOpt())) {
                this.optionalValue = cmd.getOptionValue(Options.OPTIONAL.getLongOpt());
            }
            this.booleanValue = this.booleanValue || cmd.hasOption(Options.BOOLEAN.getLongOpt());
        }

        protected void processOldArgs(List<String> args) {
            ArrayList<String> invalidArgs = new ArrayList<String>();
            while (args.size() > 0) {
                String cmd = args.remove(0);
                if (cmd.equals("-opt")) {
                    this.optionalValue = args.remove(0);
                    continue;
                }
                if (cmd.equals("-bool")) {
                    this.booleanValue = true;
                    continue;
                }
                invalidArgs.add(cmd);
            }
            args.addAll(invalidArgs);
        }

        protected int doWork() throws Exception {
            return 0;
        }
    }

    static final class Options {
        static final Option REQUIRED = new Option(null, "required", true, "");
        static final Option OPTIONAL = new Option(null, "optional", true, "");
        static final Option BOOLEAN = new Option(null, "boolean", false, "");

        Options() {
        }
    }
}

