/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import ch.cern.hbase.thirdparty.com.google.common.escape.Escaper;
import ch.cern.hbase.thirdparty.com.google.common.escape.Escapers;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class JRubyFormat {
    private static final Escaper escaper = Escapers.builder().addEscape('\\', "\\\\").addEscape('\'', "\\'").addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").addEscape('\f', "\\f").build();

    private JRubyFormat() {
    }

    private static String escape(Object object) {
        if (object == null) {
            return "";
        }
        return escaper.escape(object.toString());
    }

    private static void appendJRuby(StringBuilder builder, Object object) {
        if (object == null) {
            builder.append("''");
        } else if (object instanceof List) {
            builder.append("[");
            boolean first = true;
            for (Object element : (List)object) {
                if (first) {
                    first = false;
                    builder.append(" ");
                } else {
                    builder.append(", ");
                }
                JRubyFormat.appendJRuby(builder, element);
            }
            if (!first) {
                builder.append(" ");
            }
            builder.append("]");
        } else if (object instanceof Map) {
            builder.append("{");
            boolean first = true;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (first) {
                    first = false;
                    builder.append(" ");
                } else {
                    builder.append(", ");
                }
                String key = (String)entry.getKey();
                String escapedKey = JRubyFormat.escape(key);
                if (key.equals(escapedKey)) {
                    builder.append(key);
                } else {
                    builder.append("'").append(escapedKey).append("'");
                }
                builder.append(" => ");
                JRubyFormat.appendJRuby(builder, entry.getValue());
            }
            if (!first) {
                builder.append(" ");
            }
            builder.append("}");
        } else if (object instanceof byte[]) {
            String byteString = Bytes.toHex((byte[])object);
            builder.append("'").append(JRubyFormat.escape(byteString)).append("'");
        } else {
            builder.append("'").append(JRubyFormat.escape(object)).append("'");
        }
    }

    public static String print(Object object) {
        StringBuilder builder = new StringBuilder();
        JRubyFormat.appendJRuby(builder, object);
        return builder.toString();
    }
}

