/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;
import org.apache.yetus.audience.InterfaceAudience;

@Deprecated
@InterfaceAudience.Private
public class SecureBulkLoadEndpointClient {
    private Table table;

    public SecureBulkLoadEndpointClient(Table table) {
        this.table = table;
    }

    public String prepareBulkLoad(TableName tableName) throws IOException {
        try {
            CoprocessorRpcChannel channel = this.table.coprocessorService(HConstants.EMPTY_START_ROW);
            SecureBulkLoadProtos.SecureBulkLoadService instance = (SecureBulkLoadProtos.SecureBulkLoadService)ProtobufUtil.newServiceStub(SecureBulkLoadProtos.SecureBulkLoadService.class, (RpcChannel)channel);
            ServerRpcController controller = new ServerRpcController();
            CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
            ClientProtos.PrepareBulkLoadRequest request = ClientProtos.PrepareBulkLoadRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)tableName)).build();
            instance.prepareBulkLoad((RpcController)controller, request, (RpcCallback)rpcCallback);
            ClientProtos.PrepareBulkLoadResponse response = (ClientProtos.PrepareBulkLoadResponse)rpcCallback.get();
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
            return response.getBulkToken();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public void cleanupBulkLoad(String bulkToken) throws IOException {
        try {
            CoprocessorRpcChannel channel = this.table.coprocessorService(HConstants.EMPTY_START_ROW);
            SecureBulkLoadProtos.SecureBulkLoadService instance = (SecureBulkLoadProtos.SecureBulkLoadService)ProtobufUtil.newServiceStub(SecureBulkLoadProtos.SecureBulkLoadService.class, (RpcChannel)channel);
            ServerRpcController controller = new ServerRpcController();
            CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
            ClientProtos.CleanupBulkLoadRequest request = ClientProtos.CleanupBulkLoadRequest.newBuilder().setBulkToken(bulkToken).build();
            instance.cleanupBulkLoad((RpcController)controller, request, (RpcCallback)rpcCallback);
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, Token<?> userToken, String bulkToken, byte[] startRow) throws IOException {
        try {
            CoprocessorRpcChannel channel = this.table.coprocessorService(startRow);
            SecureBulkLoadProtos.SecureBulkLoadService instance = (SecureBulkLoadProtos.SecureBulkLoadService)ProtobufUtil.newServiceStub(SecureBulkLoadProtos.SecureBulkLoadService.class, (RpcChannel)channel);
            ClientProtos.DelegationToken protoDT = ClientProtos.DelegationToken.newBuilder().build();
            if (userToken != null) {
                protoDT = ClientProtos.DelegationToken.newBuilder().setIdentifier(ByteStringer.wrap((byte[])userToken.getIdentifier())).setPassword(ByteStringer.wrap((byte[])userToken.getPassword())).setKind(userToken.getKind().toString()).setService(userToken.getService().toString()).build();
            }
            ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath> protoFamilyPaths = new ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath>(familyPaths.size());
            for (Pair<byte[], String> el : familyPaths) {
                protoFamilyPaths.add(ClientProtos.BulkLoadHFileRequest.FamilyPath.newBuilder().setFamily(ByteStringer.wrap((byte[])((byte[])el.getFirst()))).setPath((String)el.getSecond()).build());
            }
            SecureBulkLoadProtos.SecureBulkLoadHFilesRequest request = SecureBulkLoadProtos.SecureBulkLoadHFilesRequest.newBuilder().setFsToken(protoDT).addAllFamilyPath(protoFamilyPaths).setBulkToken(bulkToken).build();
            ServerRpcController controller = new ServerRpcController();
            CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
            instance.secureBulkLoadHFiles((RpcController)controller, request, (RpcCallback)rpcCallback);
            SecureBulkLoadProtos.SecureBulkLoadHFilesResponse response = (SecureBulkLoadProtos.SecureBulkLoadHFilesResponse)rpcCallback.get();
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
            return response.getLoaded();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }
}

