/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.util.Threads;

public class ProtobufCoprocessorService
extends TestRpcServiceProtos.TestProtobufRpcProto
implements MasterCoprocessor,
RegionCoprocessor {
    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    public void ping(RpcController controller, TestProtos.EmptyRequestProto request, RpcCallback<TestProtos.EmptyResponseProto> done) {
        done.run((Object)TestProtos.EmptyResponseProto.getDefaultInstance());
    }

    public void echo(RpcController controller, TestProtos.EchoRequestProto request, RpcCallback<TestProtos.EchoResponseProto> done) {
        String message = request.getMessage();
        done.run((Object)TestProtos.EchoResponseProto.newBuilder().setMessage(message).build());
    }

    public void error(RpcController controller, TestProtos.EmptyRequestProto request, RpcCallback<TestProtos.EmptyResponseProto> done) {
        CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)new IOException("Test exception"));
        done.run(null);
    }

    public void pause(RpcController controller, TestProtos.PauseRequestProto request, RpcCallback<TestProtos.EmptyResponseProto> done) {
        Threads.sleepWithoutInterrupt((long)request.getMs());
        done.run((Object)TestProtos.EmptyResponseProto.getDefaultInstance());
    }

    public void addr(RpcController controller, TestProtos.EmptyRequestProto request, RpcCallback<TestProtos.AddrResponseProto> done) {
        done.run((Object)TestProtos.AddrResponseProto.newBuilder().setAddr(((InetAddress)RpcServer.getRemoteAddress().get()).getHostAddress()).build());
    }

    public void start(CoprocessorEnvironment env) throws IOException {
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

