/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import ch.cern.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SecureBulkLoadManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoreCoprocessor
@InterfaceAudience.Private
@Deprecated
public class SecureBulkLoadEndpoint
extends SecureBulkLoadProtos.SecureBulkLoadService
implements RegionCoprocessor {
    public static final long VERSION = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(SecureBulkLoadEndpoint.class);
    private RegionCoprocessorEnvironment env;
    private RegionServerServices rsServices;

    public void start(CoprocessorEnvironment env) {
        this.env = (RegionCoprocessorEnvironment)env;
        this.rsServices = ((HasRegionServerServices)this.env).getRegionServerServices();
        LOG.warn("SecureBulkLoadEndpoint is deprecated. It will be removed in future releases.");
        LOG.warn("Secure bulk load has been integrated into HBase core.");
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public void prepareBulkLoad(RpcController controller, ClientProtos.PrepareBulkLoadRequest request, RpcCallback<ClientProtos.PrepareBulkLoadResponse> done) {
        try {
            SecureBulkLoadManager secureBulkLoadManager = this.rsServices.getSecureBulkLoadManager();
            String bulkToken = secureBulkLoadManager.prepareBulkLoad((HRegion)this.env.getRegion(), this.convert(request));
            done.run((Object)ClientProtos.PrepareBulkLoadResponse.newBuilder().setBulkToken(bulkToken).build());
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(null);
    }

    ClientProtos.PrepareBulkLoadRequest convert(ClientProtos.PrepareBulkLoadRequest request) throws InvalidProtocolBufferException {
        byte[] bytes = request.toByteArray();
        ClientProtos.PrepareBulkLoadRequest.Builder builder = ClientProtos.PrepareBulkLoadRequest.newBuilder();
        builder.mergeFrom(bytes);
        return builder.build();
    }

    @Override
    public void cleanupBulkLoad(RpcController controller, ClientProtos.CleanupBulkLoadRequest request, RpcCallback<ClientProtos.CleanupBulkLoadResponse> done) {
        try {
            SecureBulkLoadManager secureBulkLoadManager = this.rsServices.getSecureBulkLoadManager();
            secureBulkLoadManager.cleanupBulkLoad((HRegion)this.env.getRegion(), this.convert(request));
            done.run((Object)ClientProtos.CleanupBulkLoadResponse.newBuilder().build());
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(null);
    }

    ClientProtos.CleanupBulkLoadRequest convert(ClientProtos.CleanupBulkLoadRequest request) throws InvalidProtocolBufferException {
        byte[] bytes = request.toByteArray();
        ClientProtos.CleanupBulkLoadRequest.Builder builder = ClientProtos.CleanupBulkLoadRequest.newBuilder();
        builder.mergeFrom(bytes);
        return builder.build();
    }

    @Override
    public void secureBulkLoadHFiles(RpcController controller, SecureBulkLoadProtos.SecureBulkLoadHFilesRequest request, RpcCallback<SecureBulkLoadProtos.SecureBulkLoadHFilesResponse> done) {
        boolean loaded = false;
        Map map = null;
        try {
            SecureBulkLoadManager secureBulkLoadManager = this.rsServices.getSecureBulkLoadManager();
            ClientProtos.BulkLoadHFileRequest bulkLoadHFileRequest = this.ConvertSecureBulkLoadHFilesRequest(request);
            map = secureBulkLoadManager.secureBulkLoadHFiles((HRegion)this.env.getRegion(), this.convert(bulkLoadHFileRequest));
            loaded = map != null && !map.isEmpty();
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)SecureBulkLoadProtos.SecureBulkLoadHFilesResponse.newBuilder().setLoaded(loaded).build());
    }

    ClientProtos.BulkLoadHFileRequest convert(ClientProtos.BulkLoadHFileRequest request) throws InvalidProtocolBufferException {
        byte[] bytes = request.toByteArray();
        ClientProtos.BulkLoadHFileRequest.Builder builder = ClientProtos.BulkLoadHFileRequest.newBuilder();
        builder.mergeFrom(bytes);
        return builder.build();
    }

    private ClientProtos.BulkLoadHFileRequest ConvertSecureBulkLoadHFilesRequest(SecureBulkLoadProtos.SecureBulkLoadHFilesRequest request) {
        ClientProtos.BulkLoadHFileRequest.Builder bulkLoadHFileRequest = ClientProtos.BulkLoadHFileRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = ProtobufUtil.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])this.env.getRegionInfo().getRegionName());
        bulkLoadHFileRequest.setRegion(region).setFsToken(request.getFsToken()).setBulkToken(request.getBulkToken()).setAssignSeqNum(request.getAssignSeqNum()).addAllFamilyPath(request.getFamilyPathList());
        return bulkLoadHFileRequest.build();
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }
}

