/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.example.AsyncClientExample;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncClientExample {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncClientExample.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, Bytes.toBytes((String)"d"));
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        AsyncClientExample tool = new AsyncClientExample();
        tool.setConf(UTIL.getConfiguration());
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)tool, (String[])new String[]{TABLE_NAME.getNameAsString()}));
    }
}

