/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.example.HttpProxyExample;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestHttpProxyExample {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHttpProxyExample.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final String FAMILY = "cf";
    private static final String QUALIFIER = "cq";
    private static final String URL_TEMPLCATE = "http://localhost:%d/%s/%s/%s:%s";
    private static final String ROW = "row";
    private static final String VALUE = "value";
    private static HttpProxyExample PROXY;
    private static int PORT;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, Bytes.toBytes((String)FAMILY));
        PROXY = new HttpProxyExample(UTIL.getConfiguration(), 0);
        PROXY.start();
        PORT = PROXY.port();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (PROXY != null) {
            PROXY.stop();
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPut put = new HttpPut(String.format(URL_TEMPLCATE, PORT, TABLE_NAME.getNameAsString(), ROW, FAMILY, QUALIFIER));
            put.setEntity(EntityBuilder.create().setText(VALUE).setContentType(ContentType.create((String)"text-plain", (Charset)StandardCharsets.UTF_8)).build());
            try (CloseableHttpResponse resp = client.execute((HttpUriRequest)put);){
                Assert.assertEquals((long)200L, (long)resp.getStatusLine().getStatusCode());
            }
            HttpGet get = new HttpGet(String.format(URL_TEMPLCATE, PORT, TABLE_NAME.getNameAsString(), ROW, FAMILY, QUALIFIER));
            try (CloseableHttpResponse resp = client.execute((HttpUriRequest)get);){
                Assert.assertEquals((long)200L, (long)resp.getStatusLine().getStatusCode());
                Assert.assertEquals((Object)VALUE, (Object)Bytes.toString((byte[])ByteStreams.toByteArray((InputStream)resp.getEntity().getContent())));
            }
            get = new HttpGet(String.format(URL_TEMPLCATE, PORT, TABLE_NAME.getNameAsString(), "whatever", FAMILY, QUALIFIER));
            resp = client.execute((HttpUriRequest)get);
            var6_10 = null;
            try {
                Assert.assertEquals((long)404L, (long)resp.getStatusLine().getStatusCode());
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (resp != null) {
                    if (var6_10 != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        resp.close();
                    }
                }
            }
        }
    }
}

