/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.example.RefreshHFilesClient;
import org.apache.hadoop.hbase.coprocessor.example.RefreshHFilesEndpoint;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRefreshHFilesEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRefreshHFilesEndpoint.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRefreshHFilesEndpoint.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final int NUM_MASTER = 1;
    private static final int NUM_RS = 2;
    private static final TableName TABLE_NAME = TableName.valueOf((String)"testRefreshRegionHFilesEP");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
    private static final byte[][] SPLIT_KEY = new byte[][]{Bytes.toBytes((String)"30")};
    private static final int NUM_ROWS = 5;
    private static final String HFILE_NAME = "123abcdef";
    private static Configuration CONF = HTU.getConfiguration();
    private static MiniHBaseCluster cluster;
    private static Table table;

    public static void setUp(String regionImpl) {
        try {
            CONF.set("hbase.hregion.impl", regionImpl);
            CONF.setInt("hbase.client.retries.number", 2);
            CONF.setStrings("hbase.coprocessor.region.classes", new String[]{RefreshHFilesEndpoint.class.getName()});
            cluster = HTU.startMiniCluster(1, 2);
            table = HTU.createTable(TABLE_NAME, FAMILY, SPLIT_KEY);
            HTU.loadNumericRows(table, FAMILY, 1, 20);
            HTU.flush(TABLE_NAME);
        }
        catch (Exception ex) {
            LOG.error("Couldn't finish setup", (Throwable)ex);
        }
    }

    @After
    public void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testRefreshRegionHFilesEndpoint() throws Exception {
        TestRefreshHFilesEndpoint.setUp(HRegion.class.getName());
        MasterFileSystem mfs = HTU.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)TABLE_NAME);
        for (Region region : cluster.getRegions(TABLE_NAME)) {
            Path regionDir = new Path(tableDir, region.getRegionInfo().getEncodedName());
            Path familyDir = new Path(regionDir, Bytes.toString((byte[])FAMILY));
            HFileTestUtil.createHFile((Configuration)HTU.getConfiguration(), (FileSystem)HTU.getTestFileSystem(), (Path)new Path(familyDir, HFILE_NAME), (byte[])FAMILY, (byte[])QUALIFIER, (byte[])Bytes.toBytes((String)"50"), (byte[])Bytes.toBytes((String)"60"), (int)5);
        }
        Assert.assertEquals((long)2L, (long)HTU.getNumHFiles(TABLE_NAME, FAMILY));
        this.callRefreshRegionHFilesEndPoint();
        Assert.assertEquals((long)4L, (long)HTU.getNumHFiles(TABLE_NAME, FAMILY));
    }

    @Test(expected=IOException.class)
    public void testRefreshRegionHFilesEndpointWithException() throws IOException {
        TestRefreshHFilesEndpoint.setUp(HRegionForRefreshHFilesEP.class.getName());
        this.callRefreshRegionHFilesEndPoint();
    }

    private void callRefreshRegionHFilesEndPoint() throws IOException {
        try {
            RefreshHFilesClient refreshHFilesClient = new RefreshHFilesClient(CONF);
            refreshHFilesClient.refreshHFiles(TABLE_NAME);
        }
        catch (RetriesExhaustedException rex) {
            if (rex.getCause() instanceof IOException) {
                throw new IOException();
            }
        }
        catch (Throwable ex) {
            LOG.error(ex.toString(), ex);
            Assert.fail((String)"Couldn't call the RefreshRegionHFilesEndpoint");
        }
    }

    public static class HStoreWithFaultyRefreshHFilesAPI
    extends HStore {
        public HStoreWithFaultyRefreshHFilesAPI(HRegion region, ColumnFamilyDescriptor family, Configuration confParam) throws IOException {
            super(region, family, confParam);
        }

        public void refreshStoreFiles() throws IOException {
            throw new IOException();
        }
    }

    public static class HRegionForRefreshHFilesEP
    extends HRegion {
        HStoreWithFaultyRefreshHFilesAPI store;

        public HRegionForRefreshHFilesEP(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public List<HStore> getStores() {
            ArrayList<HStore> list = new ArrayList<HStore>(this.stores.size());
            try {
                if (this.store == null) {
                    this.store = new HStoreWithFaultyRefreshHFilesAPI(this, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY), this.conf);
                }
                list.add(this.store);
            }
            catch (IOException ioe) {
                LOG.info("Couldn't instantiate custom store implementation", (Throwable)ioe);
            }
            list.addAll(this.stores.values());
            return list;
        }
    }
}

